/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultClientMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetricManager;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientTaskMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultRequestMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultTcpSocketMetric;

public class DefaultHttpClientMetrics
implements HttpClientMetrics<DefaultRequestMetric, Object, DefaultTcpSocketMetric, DefaultClientTaskMetric> {
    private static final String PROTOCOL = "http://";
    private final DefaultClientEndpointMetricManager clientEndpointMetricManager;

    public DefaultHttpClientMetrics(DefaultClientEndpointMetricManager clientEndpointMetricManager) {
        this.clientEndpointMetricManager = clientEndpointMetricManager;
    }

    public DefaultClientMetrics createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
        return new DefaultClientMetrics(this.getOrCreateEndpointMetric(remoteAddress));
    }

    private DefaultClientEndpointMetric getOrCreateEndpointMetric(SocketAddress remoteAddress) {
        return this.clientEndpointMetricManager.getOrCreateEndpointMetric(PROTOCOL + remoteAddress.host() + ":" + remoteAddress.port());
    }

    public DefaultTcpSocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        DefaultTcpSocketMetric socketMetric = new DefaultTcpSocketMetric(this.getOrCreateEndpointMetric(remoteAddress));
        socketMetric.onConnect();
        return socketMetric;
    }

    public void disconnected(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.onDisconnect();
    }

    public void bytesRead(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.getEndpointMetric().addBytesRead(numberOfBytes);
    }

    public void bytesWritten(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.getEndpointMetric().addBytesWritten(numberOfBytes);
    }
}

