/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.consumer;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.parameters.Parameter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.LambdaMetafactoryUtils;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;
import org.apache.servicecomb.swagger.invocation.arguments.AbstractArgumentsMapperCreator;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ArgumentsMapperCommon;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ArgumentsMapperDirectReuse;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentSame;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentToBodyField;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerBeanParamMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerArgumentsMapperCreator
extends AbstractArgumentsMapperCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerArgumentsMapperCreator.class);
    private int unknownConsumerParams = 0;

    public ConsumerArgumentsMapperCreator(SerializationConfig serializationConfig, Map<Class<?>, ContextArgumentMapperFactory> contextFactorys, Class<?> consumerClass, Method consumerMethod, SwaggerOperation swaggerOperation) {
        super(serializationConfig, contextFactorys, consumerClass, consumerMethod, swaggerOperation);
    }

    private boolean isAllSameMapper() {
        for (ArgumentMapper mapper : this.mappers) {
            if (mapper instanceof ConsumerArgumentSame && ((ConsumerArgumentSame)mapper).isSameMapping()) continue;
            return false;
        }
        return true;
    }

    public ArgumentsMapper createArgumentsMapper() {
        this.doCreateArgumentsMapper();
        if (this.unknownConsumerParams == 0 && this.mappers.size() == this.swaggerOperation.getOperation().getParameters().size() && this.isAllSameMapper()) {
            return new ArgumentsMapperDirectReuse();
        }
        return new ArgumentsMapperCommon(this.mappers);
    }

    @Override
    protected void processUnknownParameter(int providerParamIdx, java.lang.reflect.Parameter providerParameter, String parameterName) {
        Parameter parameter;
        if (!this.isSwaggerBodyField && this.notProcessedSwaggerParamIdx < this.swaggerParameters.size() && (parameter = (Parameter)this.swaggerParameters.get(this.notProcessedSwaggerParamIdx)) != null) {
            ArgumentMapper mapper = this.createKnownParameterMapper(providerParamIdx, this.notProcessedSwaggerParamIdx);
            this.mappers.add(mapper);
            this.processedSwaggerParamters.add(parameterName);
            ++this.notProcessedSwaggerParamIdx;
            LOGGER.warn("Old consumer invoke new version producer, parameter({}) is not exist in contract, method={}:{}. Please change consumer parameter name to match swagger.", new Object[]{parameterName, this.providerMethod.getDeclaringClass().getName(), this.providerMethod.getName()});
            return;
        }
        LOGGER.warn("new consumer invoke old version producer, parameter({}) is not exist in contract, method={}:{}.", new Object[]{parameterName, this.providerMethod.getDeclaringClass().getName(), this.providerMethod.getName()});
        ++this.unknownConsumerParams;
    }

    @Override
    protected void processPendingSwaggerParameter(Parameter parameter) {
    }

    @Override
    protected ArgumentMapper createKnownParameterMapper(int consumerParamIdx, Integer swaggerIdx) {
        return new ConsumerArgumentSame(this.providerMethod.getParameters()[consumerParamIdx].getName(), ((Parameter)this.swaggerParameters.get(swaggerIdx)).getName());
    }

    @Override
    protected ArgumentMapper createSwaggerBodyFieldMapper(int consumerParamIdx, String parameterName, int swaggerBodyIdx) {
        return new ConsumerArgumentToBodyField(this.providerMethod.getParameters()[consumerParamIdx].getName(), ((Parameter)this.swaggerParameters.get(swaggerBodyIdx)).getName(), parameterName);
    }

    @Override
    protected boolean processBeanParameter(int consumerParamIdx, java.lang.reflect.Parameter consumerParameter) {
        JavaType providerType = TypeFactory.defaultInstance().constructType(consumerParameter.getParameterizedType());
        if (!SwaggerUtils.isBean((Type)providerType)) {
            return false;
        }
        boolean result = false;
        ConsumerBeanParamMapper mapper = new ConsumerBeanParamMapper(this.providerMethod.getParameters()[consumerParamIdx].getName());
        JavaType consumerType = TypeFactory.defaultInstance().constructType(consumerParameter.getParameterizedType());
        for (BeanPropertyDefinition propertyDefinition : this.serializationConfig.introspect(consumerType).findProperties()) {
            String parameterName = SwaggerGeneratorUtils.collectParameterName((Method)this.providerMethod, (BeanPropertyDefinition)propertyDefinition);
            Integer swaggerIdx = this.findSwaggerParameterIndex(parameterName);
            if (swaggerIdx == null) {
                LOGGER.warn("new consumer invoke old version producer, bean parameter({}) is not exist in contract, method={}:{}.", new Object[]{parameterName, this.providerMethod.getDeclaringClass().getName(), this.providerMethod.getName()});
                continue;
            }
            mapper.addField(parameterName, (Getter<Object, Object>)LambdaMetafactoryUtils.createObjectGetter((BeanPropertyDefinition)propertyDefinition));
            this.processedSwaggerParamters.add(parameterName);
            result = true;
        }
        this.mappers.add(mapper);
        return result;
    }
}

