/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.net;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtils.class);
    private static final String IPV4_KEY = "_v4";
    private static final String IPV6_KEY = "_v6";
    private static final String PREFERRED_INTERFACE = "eth";
    private static Map<String, InetAddress> allInterfaceAddresses = new HashMap<String, InetAddress>();
    private static String hostName;
    private static String hostAddress;
    private static String hostAddressIpv6;

    private static void doGetHostNameAndHostAddress() {
        block4: {
            try {
                NetUtils.doGetAddressFromNetworkInterface();
                InetAddress localHost = InetAddress.getLocalHost();
                hostName = localHost.getHostName();
                LOGGER.info("localhost hostName={}, hostAddress={}.", (Object)hostName, (Object)localHost.getHostAddress());
                if (!NetUtils.isLocalAddress(localHost)) {
                    if (Inet6Address.class.isInstance(localHost)) {
                        hostAddressIpv6 = NetUtils.trimIpv6(localHost.getHostAddress());
                        hostAddress = NetUtils.tryGetHostAddressFromNetworkInterface(false, localHost);
                        LOGGER.info("Host address info ipV4={}, ipV6={}.", (Object)hostAddress, (Object)hostAddressIpv6);
                        return;
                    }
                    hostAddress = localHost.getHostAddress();
                    hostAddressIpv6 = NetUtils.trimIpv6(NetUtils.tryGetHostAddressFromNetworkInterface(true, localHost));
                    LOGGER.info("Host address info ipV4={}, ipV6={}.", (Object)hostAddress, (Object)hostAddressIpv6);
                    return;
                }
                hostAddressIpv6 = NetUtils.trimIpv6(NetUtils.tryGetHostAddressFromNetworkInterface(true, localHost));
                hostAddress = NetUtils.tryGetHostAddressFromNetworkInterface(false, localHost);
                LOGGER.info("Host address info ipV4={}, ipV6={}.", (Object)hostAddress, (Object)hostAddressIpv6);
            }
            catch (Exception e) {
                LOGGER.error("got exception when trying to get addresses:", (Throwable)e);
                if (allInterfaceAddresses.size() < 1) break block4;
                InetAddress entry = allInterfaceAddresses.entrySet().iterator().next().getValue();
                hostName = entry.getHostName();
                hostAddress = entry.getHostAddress();
                LOGGER.info("add host name from interfaces:" + hostName + ",host address:" + hostAddress);
            }
        }
    }

    private static String tryGetHostAddressFromNetworkInterface(boolean isIpv6, InetAddress localhost) {
        InetAddress result = null;
        for (Map.Entry<String, InetAddress> entry : allInterfaceAddresses.entrySet()) {
            if (isIpv6 && entry.getKey().endsWith(IPV6_KEY)) {
                result = entry.getValue();
                if (!entry.getKey().startsWith(PREFERRED_INTERFACE)) continue;
                return result.getHostAddress();
            }
            if (isIpv6 || !entry.getKey().endsWith(IPV4_KEY)) continue;
            result = entry.getValue();
            if (!entry.getKey().startsWith(PREFERRED_INTERFACE)) continue;
            return result.getHostAddress();
        }
        if (result == null) {
            return localhost.getHostAddress();
        }
        return result.getHostAddress();
    }

    private NetUtils() {
    }

    private static void doGetAddressFromNetworkInterface() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface network = networkInterfaces.nextElement();
            if (!network.isUp() || network.isLoopback() || network.isVirtual()) continue;
            Enumeration<InetAddress> addresses = network.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (NetUtils.isLocalAddress(address)) continue;
                if (address instanceof Inet4Address) {
                    LOGGER.info("add ipv4 network interface:" + network.getName() + ",host address:" + address.getHostAddress());
                    allInterfaceAddresses.put(network.getName() + IPV4_KEY, address);
                    continue;
                }
                if (!(address instanceof Inet6Address)) continue;
                LOGGER.info("add ipv6 network interface:" + network.getName() + ",host address:" + address.getHostAddress());
                allInterfaceAddresses.put(network.getName() + IPV6_KEY, address);
            }
        }
    }

    private static String trimIpv6(String hostAddress) {
        int index = hostAddress.indexOf("%");
        if (index >= 0) {
            return hostAddress.substring(0, index);
        }
        return hostAddress;
    }

    private static boolean isLocalAddress(InetAddress address) {
        return address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isMulticastAddress();
    }

    public static IpPort parseIpPort(String address) {
        if (address == null) {
            return null;
        }
        URI uri = URI.create("http://" + address);
        return NetUtils.parseIpPort(uri, true);
    }

    public static IpPort parseIpPort(URI uri) {
        return NetUtils.parseIpPort(uri, false);
    }

    public static IpPort parseIpPort(URI uri, boolean ignorePortUndefined) {
        if (null == uri.getHost()) {
            throw new IllegalArgumentException("Illegal uri: [" + uri + "]");
        }
        IpPort ipPort = new IpPort(uri.getHost(), uri.getPort());
        if (-1 != ipPort.getPort() || ignorePortUndefined) {
            return ipPort;
        }
        if (uri.getScheme().equals("http")) {
            ipPort.setPort(80);
        }
        if (uri.getScheme().equals("https")) {
            ipPort.setPort(443);
        }
        return ipPort;
    }

    public static IpPort parseIpPortFromURI(String uriAddress) {
        if (uriAddress == null) {
            return null;
        }
        try {
            return NetUtils.parseIpPort(new URI(uriAddress));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static IpPort parseIpPort(String scheme, String authority) {
        if (authority == null) {
            return null;
        }
        return NetUtils.parseIpPort(URI.create(scheme + "://" + authority));
    }

    public static String getRealListenAddress(String schema, String address) {
        if (address == null) {
            return null;
        }
        try {
            URI originalURI = new URI(schema + "://" + address);
            NetUtils.parseIpPort(originalURI);
            return originalURI.toString();
        }
        catch (URISyntaxException e) {
            LOGGER.error("address {} is not valid.", (Object)address);
            return null;
        }
    }

    public static String getHostName() {
        if (hostName == null) {
            NetUtils.doGetHostNameAndHostAddress();
        }
        return hostName;
    }

    @VisibleForTesting
    static void resetHostName() {
        hostName = null;
    }

    public static String getHostAddress() {
        if (hostAddress == null) {
            NetUtils.doGetHostNameAndHostAddress();
        }
        return hostAddress;
    }

    public static String getIpv6HostAddress() {
        if (hostAddressIpv6 == null) {
            NetUtils.doGetHostNameAndHostAddress();
        }
        return hostAddressIpv6;
    }

    public static InetAddress getInterfaceAddress(String interfaceName) {
        return allInterfaceAddresses.get(interfaceName);
    }

    public static InetAddress ensureGetInterfaceAddress(String interfaceName) {
        InetAddress address = allInterfaceAddresses.get(interfaceName);
        if (address == null) {
            throw new IllegalArgumentException("Can not find address for interface name: " + interfaceName);
        }
        return address;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canTcpListen(InetAddress address, int port) {
        try (ServerSocket ss = new ServerSocket(port, 0, address);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String humanReadableBytes(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.3f%c", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    static {
        NetUtils.doGetHostNameAndHostAddress();
    }
}

