/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
#pragma once

#ifdef USE_ASIO
#include <asio/steady_timer.hpp>
#else
#include <boost/asio/steady_timer.hpp>
#endif

#include <memory>

#include "AsioDefines.h"

using DeadlineTimerPtr = std::shared_ptr<ASIO::steady_timer>;

inline void cancelTimer(ASIO::steady_timer& timer) {
    try {
        timer.cancel();
    } catch (const ASIO_SYSTEM_ERROR& ignored) {
        // Most of the time the exception can be ignored unless the following logic depends on the fact that
        // the timer is cancelled.
    }
}
