/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.function.Supplier;
import lombok.Generated;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations to collect function-worker statistics"})
public class CmdFunctionWorker
extends CmdBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CmdFunctionWorker.class);

    public CmdFunctionWorker(Supplier<PulsarAdmin> admin) throws PulsarClientException {
        super("functions-worker", admin);
        this.addCommand("function-stats", new FunctionsStats());
        this.addCommand("monitoring-metrics", new CmdMonitoringMetrics());
        this.addCommand("get-cluster", new GetCluster());
        this.addCommand("get-cluster-leader", new GetClusterLeader());
        this.addCommand("get-function-assignments", new GetFunctionAssignments());
        this.addCommand("rebalance", new Rebalance());
    }

    @CommandLine.Command(description={"Dump all functions stats running on this broker"})
    class FunctionsStats
    extends BaseCommand {
        FunctionsStats() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getFunctionsStats());
        }
    }

    @CommandLine.Command(description={"Dump metrics for Monitoring"})
    class CmdMonitoringMetrics
    extends BaseCommand {
        CmdMonitoringMetrics() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getMetrics());
        }
    }

    @CommandLine.Command(description={"Get all workers belonging to this cluster"})
    class GetCluster
    extends BaseCommand {
        GetCluster() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getCluster());
        }
    }

    @CommandLine.Command(description={"Get the leader of the worker cluster"})
    class GetClusterLeader
    extends BaseCommand {
        GetClusterLeader() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getClusterLeader());
        }
    }

    @CommandLine.Command(description={"Get the assignments of the functions across the worker cluster"})
    class GetFunctionAssignments
    extends BaseCommand {
        GetFunctionAssignments() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getAssignments());
        }
    }

    @CommandLine.Command(description={"Triggers a rebalance of functions to workers"})
    class Rebalance
    extends BaseCommand {
        Rebalance() {
        }

        @Override
        void runCmd() throws Exception {
            CmdFunctionWorker.this.getAdmin().worker().rebalance();
            this.print("Rebalance command sent successfully");
        }
    }

    abstract class BaseCommand
    extends CliCommand {
        BaseCommand() {
        }

        @Override
        void run() throws Exception {
            this.processArguments();
            this.runCmd();
        }

        void processArguments() throws Exception {
        }

        abstract void runCmd() throws Exception;
    }
}

