/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7discovery.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnDcp_Pdu_IdentifyReq extends PnDcp_Pdu implements Message {

  // Accessors for discriminator values.

  // Constant values.
  public static final Short SERVICEID = 0x05;
  public static final Boolean NOTSUPPORTED = false;
  public static final Boolean RESPONSE = false;

  // Properties.
  protected final long xid;
  protected final int responseDelay;
  protected final List<PnDcp_Block> blocks;

  public PnDcp_Pdu_IdentifyReq(
      int frameIdValue, long xid, int responseDelay, List<PnDcp_Block> blocks) {
    super(frameIdValue);
    this.xid = xid;
    this.responseDelay = responseDelay;
    this.blocks = blocks;
  }

  public long getXid() {
    return xid;
  }

  public int getResponseDelay() {
    return responseDelay;
  }

  public List<PnDcp_Block> getBlocks() {
    return blocks;
  }

  public short getServiceId() {
    return SERVICEID;
  }

  public boolean getNotSupported() {
    return NOTSUPPORTED;
  }

  public boolean getResponse() {
    return RESPONSE;
  }

  @Override
  protected void serializePnDcp_PduChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnDcp_Pdu_IdentifyReq");

    // Const Field (serviceId)
    writeConstField(
        "serviceId",
        SERVICEID,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        (byte) 0x00,
        writeUnsignedByte(writeBuffer, 5),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (notSupported)
    writeConstField(
        "notSupported",
        NOTSUPPORTED,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        (byte) 0x00,
        writeUnsignedByte(writeBuffer, 1),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (response)
    writeConstField(
        "response",
        RESPONSE,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (xid)
    writeSimpleField(
        "xid",
        xid,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (responseDelay)
    writeSimpleField(
        "responseDelay",
        responseDelay,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (dcpDataLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int dcpDataLength = (int) ((getLengthInBytes()) - (12));
    writeImplicitField(
        "dcpDataLength",
        dcpDataLength,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Array Field (blocks)
    writeComplexTypeArrayField(
        "blocks", blocks, writeBuffer, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnDcp_Pdu_IdentifyReq");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PnDcp_Pdu_IdentifyReq _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (serviceId)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 5;

    // Const Field (notSupported)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Const Field (response)
    lengthInBits += 1;

    // Simple field (xid)
    lengthInBits += 32;

    // Simple field (responseDelay)
    lengthInBits += 16;

    // Implicit Field (dcpDataLength)
    lengthInBits += 16;

    // Array field
    if (blocks != null) {
      for (Message element : blocks) {
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static PnDcp_PduBuilder staticParsePnDcp_PduBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnDcp_Pdu_IdentifyReq");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short serviceId =
        readConstField(
            "serviceId",
            readUnsignedShort(readBuffer, 8),
            PnDcp_Pdu_IdentifyReq.SERVICEID,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Byte reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedByte(readBuffer, 5),
            (byte) 0x00,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean notSupported =
        readConstField(
            "notSupported",
            readBoolean(readBuffer),
            PnDcp_Pdu_IdentifyReq.NOTSUPPORTED,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Byte reservedField1 =
        readReservedField(
            "reserved",
            readUnsignedByte(readBuffer, 1),
            (byte) 0x00,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean response =
        readConstField(
            "response",
            readBoolean(readBuffer),
            PnDcp_Pdu_IdentifyReq.RESPONSE,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long xid =
        readSimpleField(
            "xid",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int responseDelay =
        readSimpleField(
            "responseDelay",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int dcpDataLength =
        readImplicitField(
            "dcpDataLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    List<PnDcp_Block> blocks =
        readLengthArrayField(
            "blocks",
            readComplex(() -> PnDcp_Block.staticParse(readBuffer), readBuffer),
            dcpDataLength,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnDcp_Pdu_IdentifyReq");
    // Create the instance
    return new PnDcp_Pdu_IdentifyReqBuilderImpl(xid, responseDelay, blocks);
  }

  public static class PnDcp_Pdu_IdentifyReqBuilderImpl implements PnDcp_Pdu.PnDcp_PduBuilder {
    private final long xid;
    private final int responseDelay;
    private final List<PnDcp_Block> blocks;

    public PnDcp_Pdu_IdentifyReqBuilderImpl(long xid, int responseDelay, List<PnDcp_Block> blocks) {
      this.xid = xid;
      this.responseDelay = responseDelay;
      this.blocks = blocks;
    }

    public PnDcp_Pdu_IdentifyReq build(int frameIdValue) {
      PnDcp_Pdu_IdentifyReq pnDcp_Pdu_IdentifyReq =
          new PnDcp_Pdu_IdentifyReq(frameIdValue, xid, responseDelay, blocks);
      return pnDcp_Pdu_IdentifyReq;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnDcp_Pdu_IdentifyReq)) {
      return false;
    }
    PnDcp_Pdu_IdentifyReq that = (PnDcp_Pdu_IdentifyReq) o;
    return (getXid() == that.getXid())
        && (getResponseDelay() == that.getResponseDelay())
        && (getBlocks() == that.getBlocks())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getXid(), getResponseDelay(), getBlocks());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
