/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum PnIoCm_BlockType {
  ALARM_NOTIFICATION_HIGH((int) 0x0001),
  ALARM_NOTIFICATION_LOG((int) 0x0002),
  IOD_WRITE_REQ_HEADER((int) 0x0008),
  IOD_READ_REQ_HEADER((int) 0x0009),
  DIAGNOSIS_DATA((int) 0x0010),
  EXPECTED_IDENTIFICATION_DATA((int) 0x0012),
  REAL_IDENTIFICATION_DATA((int) 0x0013),
  SUBSTITUTE_VALUE((int) 0x0014),
  RECORD_INPUT_DATA_OBJECT_ELEMENT((int) 0x0015),
  RECORD_OUTPUT_DATA_OBJECT_ELEMENT((int) 0x0016),
  AR_DATA((int) 0x0018),
  LOG_BOOK_DATA((int) 0x0019),
  API_DATA((int) 0x001A),
  SRL_DATA((int) 0x001B),
  I_AND_M_0((int) 0x0020),
  I_AND_M_1((int) 0x0021),
  I_AND_M_2((int) 0x0022),
  I_AND_M_3((int) 0x0023),
  I_AND_M_4((int) 0x0024),
  I_AND_M_5((int) 0x0025),
  I_AND_M_0_FILTER_DATA_SUBMODULE((int) 0x0030),
  I_AND_M_0_FILTER_DATA_MODULE((int) 0x0031),
  I_AND_M_0_FILTER_DATA_DEVICE((int) 0x0032),
  AM_FILTER_DATA((int) 0x0033),
  I_AND_M_5_DATA((int) 0x0034),
  ASSET_MANAGEMENT_DATA((int) 0x0035),
  ASSET_MANAGEMENT_FULL_INFORMATION((int) 0x0036),
  ASSET_MANAGEMENT_ONLY_HARDWARE_INFORMATION((int) 0x0037),
  ASSET_MANAGEMENT_ONLY_FIRMWARE_INFORMATION((int) 0x0038),
  AR_BLOCK_REQ((int) 0x0101),
  IO_CR_BLOCK_REQ((int) 0x0102),
  ALARM_CR_BLOCK_REQ((int) 0x0103),
  EXPECTED_SUBMODULE_BLOCK_REQ((int) 0x0104),
  PRM_SERVER_BLOCK((int) 0x0105),
  MCR_BLOCK_REQUEST((int) 0x0106),
  ARRPC_BLOCK_REQUEST((int) 0x0107),
  AR_VENDOR_BLOCK_REQUEST((int) 0x0108),
  IR_INFO_BLOCK((int) 0x0109),
  SR_INFO_BLOCK((int) 0x010A),
  ARFSU_BLOCK((int) 0x010B),
  RS_INFO_BLOCK((int) 0x010C),
  IOD_BLOCK_REQ_CONNECTION_PARAMETER_END((int) 0x0110),
  IOD_BLOCK_REQ_CONNECTION_PARAMETER_END_PLUG_ALARM((int) 0x0111),
  IOX_BLOCK_REQ_CONNECTION_APPLICATION_READY((int) 0x0112),
  IOX_BLOCK_REQ_CONNECTION_APPLICATION_READY_PLUG_ALARM((int) 0x0113),
  RELEASE_BLOCK_REQ((int) 0x0114),
  IOX_BLOCK_REQ_CONNECTION_READY_FOR_COMPANION((int) 0x0116),
  IOX_BLOCK_REQ_CONNECTION_READY_FOR_RT_CLASS_3((int) 0x0117),
  IOD_BLOCK_REQ_PRM_BEGIN((int) 0x0118),
  SUBMODULE_LIST_BLOCK((int) 0x0119),
  PD_PORT_DATA_CHECK((int) 0x0200),
  PDEV_DATA((int) 0x0201),
  PD_PORT_DATA_ADJUST((int) 0x0202),
  PD_SYNC_DATA((int) 0x0203),
  ISOCHRONOUS_MODE_DATA((int) 0x0204),
  PDIR_DATA((int) 0x0205),
  PDIT_GLOBAL_DATA((int) 0x0206),
  PDIR_FRAME_DATA((int) 0x0207),
  PDIR_BEGIN_END_DATA((int) 0x0208),
  ADJUST_DOMAIN_BOUNDARY((int) 0x0209),
  CHECK_PEERS((int) 0x020A),
  CHECK_LINE_DELAY((int) 0x020B),
  CHECK_MAU_TYPE((int) 0x020C),
  ADJUST_MAU_TYPE((int) 0x020E),
  PD_PORT_DATA_REAL((int) 0x020F),
  PD_INTERFACE_ADJUST((int) 0x0250),
  ALARM_ACK_HIGH((int) 0x8001),
  ALARM_ACK_LOW((int) 0x8002),
  IOD_WRITE_RES_HEADER((int) 0x8008),
  IOD_READ_RES_HEADER((int) 0x8009),
  AR_BLOCK_RES((int) 0x8101),
  IO_CR_BLOCK_RES((int) 0x8102),
  ALARM_CR_BLOCK_RES((int) 0x8103),
  MODULE_DIFF_BLOCK((int) 0x8104),
  AR_SERVER_BLOCK((int) 0x8106),
  AR_RPC_BLOCK_RES((int) 0x8007),
  AR_VENDOR_BLOCK_RES((int) 0x8008),
  IOD_BLOCK_RES_CONNECTION_PARAMETER_END((int) 0x8110),
  IOD_BLOCK_REs_CONNECTION_PARAMETER_END_PLUG_ALARM((int) 0x8111),
  IOX_BLOCK_RES_CONNECTION_APPLICATION_READY((int) 0x8112),
  IOX_BLOCK_REs_CONNECTION_APPLICATION_READY_PLUG_ALARM((int) 0x8113),
  RELEASE_BLOCK_RES((int) 0x8114),
  IOX_BLOCK_RES_CONNECT_COMPANION_READY((int) 0x8116),
  IOX_BLOCK_RES_CONNECT_RT_CLASS_3_READY((int) 0x8117),
  IOX_BLOCK_RES_CONNECT_PRM_BEGIN((int) 0x8118);
  private static final Map<Integer, PnIoCm_BlockType> map;

  static {
    map = new HashMap<>();
    for (PnIoCm_BlockType value : PnIoCm_BlockType.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  PnIoCm_BlockType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static PnIoCm_BlockType enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
