/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class QualifierOfSetPointCommand implements Message {

  // Properties.
  protected final boolean select;
  protected final byte qualifier;

  public QualifierOfSetPointCommand(boolean select, byte qualifier) {
    super();
    this.select = select;
    this.qualifier = qualifier;
  }

  public boolean getSelect() {
    return select;
  }

  public byte getQualifier() {
    return qualifier;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("QualifierOfSetPointCommand");

    // Simple Field (select)
    writeSimpleField(
        "select",
        select,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (qualifier)
    writeSimpleField(
        "qualifier",
        qualifier,
        writeUnsignedByte(writeBuffer, 7),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("QualifierOfSetPointCommand");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    QualifierOfSetPointCommand _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (select)
    lengthInBits += 1;

    // Simple field (qualifier)
    lengthInBits += 7;

    return lengthInBits;
  }

  public static QualifierOfSetPointCommand staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("QualifierOfSetPointCommand");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean select =
        readSimpleField(
            "select", readBoolean(readBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    byte qualifier =
        readSimpleField(
            "qualifier",
            readUnsignedByte(readBuffer, 7),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("QualifierOfSetPointCommand");
    // Create the instance
    QualifierOfSetPointCommand _qualifierOfSetPointCommand;
    _qualifierOfSetPointCommand = new QualifierOfSetPointCommand(select, qualifier);
    return _qualifierOfSetPointCommand;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof QualifierOfSetPointCommand)) {
      return false;
    }
    QualifierOfSetPointCommand that = (QualifierOfSetPointCommand) o;
    return (getSelect() == that.getSelect()) && (getQualifier() == that.getQualifier()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSelect(), getQualifier());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
