/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetConfirmedServiceRequestVTOpen extends BACnetConfirmedServiceRequest
    implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.VT_OPEN;
  }

  // Properties.
  protected final BACnetVTClassTagged vtClass;
  protected final BACnetApplicationTagUnsignedInteger localVtSessionIdentifier;

  // Arguments.
  protected final Long serviceRequestLength;

  public BACnetConfirmedServiceRequestVTOpen(
      BACnetVTClassTagged vtClass,
      BACnetApplicationTagUnsignedInteger localVtSessionIdentifier,
      Long serviceRequestLength) {
    super(serviceRequestLength);
    this.vtClass = vtClass;
    this.localVtSessionIdentifier = localVtSessionIdentifier;
    this.serviceRequestLength = serviceRequestLength;
  }

  public BACnetVTClassTagged getVtClass() {
    return vtClass;
  }

  public BACnetApplicationTagUnsignedInteger getLocalVtSessionIdentifier() {
    return localVtSessionIdentifier;
  }

  @Override
  protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConfirmedServiceRequestVTOpen");

    // Simple Field (vtClass)
    writeSimpleField("vtClass", vtClass, writeComplex(writeBuffer));

    // Simple Field (localVtSessionIdentifier)
    writeSimpleField(
        "localVtSessionIdentifier", localVtSessionIdentifier, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetConfirmedServiceRequestVTOpen");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetConfirmedServiceRequestVTOpen _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (vtClass)
    lengthInBits += vtClass.getLengthInBits();

    // Simple field (localVtSessionIdentifier)
    lengthInBits += localVtSessionIdentifier.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetConfirmedServiceRequestBuilder
      staticParseBACnetConfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetConfirmedServiceRequestVTOpen");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetVTClassTagged vtClass =
        readSimpleField(
            "vtClass",
            readComplex(
                () ->
                    BACnetVTClassTagged.staticParse(
                        readBuffer, (short) (0), (TagClass) (TagClass.APPLICATION_TAGS)),
                readBuffer));

    BACnetApplicationTagUnsignedInteger localVtSessionIdentifier =
        readSimpleField(
            "localVtSessionIdentifier",
            readComplex(
                () ->
                    (BACnetApplicationTagUnsignedInteger)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    readBuffer.closeContext("BACnetConfirmedServiceRequestVTOpen");
    // Create the instance
    return new BACnetConfirmedServiceRequestVTOpenBuilderImpl(
        vtClass, localVtSessionIdentifier, serviceRequestLength);
  }

  public static class BACnetConfirmedServiceRequestVTOpenBuilderImpl
      implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
    private final BACnetVTClassTagged vtClass;
    private final BACnetApplicationTagUnsignedInteger localVtSessionIdentifier;
    private final Long serviceRequestLength;

    public BACnetConfirmedServiceRequestVTOpenBuilderImpl(
        BACnetVTClassTagged vtClass,
        BACnetApplicationTagUnsignedInteger localVtSessionIdentifier,
        Long serviceRequestLength) {
      this.vtClass = vtClass;
      this.localVtSessionIdentifier = localVtSessionIdentifier;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetConfirmedServiceRequestVTOpen build(Long serviceRequestLength) {

      BACnetConfirmedServiceRequestVTOpen bACnetConfirmedServiceRequestVTOpen =
          new BACnetConfirmedServiceRequestVTOpen(
              vtClass, localVtSessionIdentifier, serviceRequestLength);
      return bACnetConfirmedServiceRequestVTOpen;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConfirmedServiceRequestVTOpen)) {
      return false;
    }
    BACnetConfirmedServiceRequestVTOpen that = (BACnetConfirmedServiceRequestVTOpen) o;
    return (getVtClass() == that.getVtClass())
        && (getLocalVtSessionIdentifier() == that.getLocalVtSessionIdentifier())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getVtClass(), getLocalVtSessionIdentifier());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
