/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ApduType {
  CONFIRMED_REQUEST_PDU((byte) 0x0),
  UNCONFIRMED_REQUEST_PDU((byte) 0x1),
  SIMPLE_ACK_PDU((byte) 0x2),
  COMPLEX_ACK_PDU((byte) 0x3),
  SEGMENT_ACK_PDU((byte) 0x4),
  ERROR_PDU((byte) 0x5),
  REJECT_PDU((byte) 0x6),
  ABORT_PDU((byte) 0x7),
  APDU_UNKNOWN_8((byte) 0x8),
  APDU_UNKNOWN_9((byte) 0x9),
  APDU_UNKNOWN_A((byte) 0xA),
  APDU_UNKNOWN_B((byte) 0xB),
  APDU_UNKNOWN_C((byte) 0xC),
  APDU_UNKNOWN_D((byte) 0xD),
  APDU_UNKNOWN_E((byte) 0xE),
  APDU_UNKNOWN_F((byte) 0xF);
  private static final Map<Byte, ApduType> map;

  static {
    map = new HashMap<>();
    for (ApduType value : ApduType.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;

  ApduType(byte value) {
    this.value = value;
  }

  public byte getValue() {
    return value;
  }

  public static ApduType enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
