/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"

	"github.com/pkg/errors"

	. "github.com/apache/plc4x/plc4go/protocols/s7/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

type S7ParserHelper struct {
}

func (m S7ParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (any, error) {
	switch typeName {
	case "SzlId":
		return SzlIdParseWithBuffer(context.Background(), io)
	case "AlarmMessageObjectAckType":
		return AlarmMessageObjectAckTypeParseWithBuffer(context.Background(), io)
	case "S7Parameter":
		messageType, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return S7ParameterParseWithBuffer[S7Parameter](context.Background(), io, messageType)
	case "S7DataAlarmMessage":
		cpuFunctionType, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return S7DataAlarmMessageParseWithBuffer[S7DataAlarmMessage](context.Background(), io, cpuFunctionType)
	case "S7PayloadUserDataItem":
		cpuFunctionGroup, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		cpuFunctionType, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		cpuSubfunction, err := utils.StrToUint8(arguments[2])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return S7PayloadUserDataItemParseWithBuffer[S7PayloadUserDataItem](context.Background(), io, cpuFunctionGroup, cpuFunctionType, cpuSubfunction)
	case "AlarmMessageObjectPushType":
		return AlarmMessageObjectPushTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessagePushType":
		return AlarmMessagePushTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageAckObjectPushType":
		return AlarmMessageAckObjectPushTypeParseWithBuffer(context.Background(), io)
	case "S7Payload":
		messageType, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		var parameter S7Parameter
		return S7PayloadParseWithBuffer[S7Payload](context.Background(), io, messageType, parameter)
	case "S7Address":
		return S7AddressParseWithBuffer[S7Address](context.Background(), io)
	case "DataItem":
		dataProtocolId, err := utils.StrToString(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		controllerType, _ := ControllerTypeByName(arguments[1])
		stringLength, err := utils.StrToInt32(arguments[2])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return DataItemParseWithBuffer(context.Background(), io, dataProtocolId, controllerType, stringLength)
	case "SubItem":
		return SubItemParseWithBuffer(context.Background(), io)
	case "CycServiceItemType":
		return CycServiceItemTypeParseWithBuffer[CycServiceItemType](context.Background(), io)
	case "AlarmMessageAckPushType":
		return AlarmMessageAckPushTypeParseWithBuffer(context.Background(), io)
	case "S7Message":
		return S7MessageParseWithBuffer[S7Message](context.Background(), io)
	case "S7VarPayloadStatusItem":
		return S7VarPayloadStatusItemParseWithBuffer(context.Background(), io)
	case "SzlDataTreeItem":
		return SzlDataTreeItemParseWithBuffer(context.Background(), io)
	case "AssociatedQueryValueType":
		return AssociatedQueryValueTypeParseWithBuffer(context.Background(), io)
	case "COTPPacket":
		cotpLen, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return COTPPacketParseWithBuffer[COTPPacket](context.Background(), io, cotpLen)
	case "DateAndTime":
		return DateAndTimeParseWithBuffer(context.Background(), io)
	case "COTPParameter":
		rest, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return COTPParameterParseWithBuffer[COTPParameter](context.Background(), io, rest)
	case "State":
		return StateParseWithBuffer(context.Background(), io)
	case "TPKTPacket":
		return TPKTPacketParseWithBuffer(context.Background(), io)
	case "Alarm8MessageQueryType":
		return Alarm8MessageQueryTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageAckType":
		return AlarmMessageAckTypeParseWithBuffer(context.Background(), io)
	case "AssociatedValueType":
		return AssociatedValueTypeParseWithBuffer(context.Background(), io)
	case "S7VarRequestParameterItem":
		return S7VarRequestParameterItemParseWithBuffer[S7VarRequestParameterItem](context.Background(), io)
	case "S7VarPayloadDataItem":
		return S7VarPayloadDataItemParseWithBuffer(context.Background(), io)
	case "AlarmMessageQueryType":
		return AlarmMessageQueryTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageAckResponseType":
		return AlarmMessageAckResponseTypeParseWithBuffer(context.Background(), io)
	case "AlarmMessageObjectQueryType":
		return AlarmMessageObjectQueryTypeParseWithBuffer(context.Background(), io)
	case "S7ParameterUserDataItem":
		return S7ParameterUserDataItemParseWithBuffer[S7ParameterUserDataItem](context.Background(), io)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
