/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonStatusMessage is the corresponding interface of JsonStatusMessage
type JsonStatusMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetMessageId returns MessageId (property field)
	GetMessageId() PascalString
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() PascalString
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetIsCyclic returns IsCyclic (property field)
	GetIsCyclic() bool
	// GetStatus returns Status (property field)
	GetStatus() PubSubState
	// GetNextReportTime returns NextReportTime (property field)
	GetNextReportTime() int64
	// IsJsonStatusMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonStatusMessage()
	// CreateBuilder creates a JsonStatusMessageBuilder
	CreateJsonStatusMessageBuilder() JsonStatusMessageBuilder
}

// _JsonStatusMessage is the data-structure of this message
type _JsonStatusMessage struct {
	ExtensionObjectDefinitionContract
	MessageId      PascalString
	MessageType    PascalString
	PublisherId    PascalString
	Timestamp      int64
	IsCyclic       bool
	Status         PubSubState
	NextReportTime int64
	// Reserved Fields
	reservedField0 *uint8
}

var _ JsonStatusMessage = (*_JsonStatusMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonStatusMessage)(nil)

// NewJsonStatusMessage factory function for _JsonStatusMessage
func NewJsonStatusMessage(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, isCyclic bool, status PubSubState, nextReportTime int64) *_JsonStatusMessage {
	if messageId == nil {
		panic("messageId of type PascalString for JsonStatusMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonStatusMessage must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type PascalString for JsonStatusMessage must not be nil")
	}
	_result := &_JsonStatusMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		MessageId:                         messageId,
		MessageType:                       messageType,
		PublisherId:                       publisherId,
		Timestamp:                         timestamp,
		IsCyclic:                          isCyclic,
		Status:                            status,
		NextReportTime:                    nextReportTime,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonStatusMessageBuilder is a builder for JsonStatusMessage
type JsonStatusMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, isCyclic bool, status PubSubState, nextReportTime int64) JsonStatusMessageBuilder
	// WithMessageId adds MessageId (property field)
	WithMessageId(PascalString) JsonStatusMessageBuilder
	// WithMessageIdBuilder adds MessageId (property field) which is build by the builder
	WithMessageIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonStatusMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonStatusMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonStatusMessageBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(PascalString) JsonStatusMessageBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonStatusMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonStatusMessageBuilder
	// WithIsCyclic adds IsCyclic (property field)
	WithIsCyclic(bool) JsonStatusMessageBuilder
	// WithStatus adds Status (property field)
	WithStatus(PubSubState) JsonStatusMessageBuilder
	// WithNextReportTime adds NextReportTime (property field)
	WithNextReportTime(int64) JsonStatusMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonStatusMessage or returns an error if something is wrong
	Build() (JsonStatusMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonStatusMessage
}

// NewJsonStatusMessageBuilder() creates a JsonStatusMessageBuilder
func NewJsonStatusMessageBuilder() JsonStatusMessageBuilder {
	return &_JsonStatusMessageBuilder{_JsonStatusMessage: new(_JsonStatusMessage)}
}

type _JsonStatusMessageBuilder struct {
	*_JsonStatusMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (JsonStatusMessageBuilder) = (*_JsonStatusMessageBuilder)(nil)

func (b *_JsonStatusMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonStatusMessage
}

func (b *_JsonStatusMessageBuilder) WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, isCyclic bool, status PubSubState, nextReportTime int64) JsonStatusMessageBuilder {
	return b.WithMessageId(messageId).WithMessageType(messageType).WithPublisherId(publisherId).WithTimestamp(timestamp).WithIsCyclic(isCyclic).WithStatus(status).WithNextReportTime(nextReportTime)
}

func (b *_JsonStatusMessageBuilder) WithMessageId(messageId PascalString) JsonStatusMessageBuilder {
	b.MessageId = messageId
	return b
}

func (b *_JsonStatusMessageBuilder) WithMessageIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonStatusMessageBuilder {
	builder := builderSupplier(b.MessageId.CreatePascalStringBuilder())
	var err error
	b.MessageId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonStatusMessageBuilder) WithMessageType(messageType PascalString) JsonStatusMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonStatusMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonStatusMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonStatusMessageBuilder) WithPublisherId(publisherId PascalString) JsonStatusMessageBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_JsonStatusMessageBuilder) WithPublisherIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonStatusMessageBuilder {
	builder := builderSupplier(b.PublisherId.CreatePascalStringBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonStatusMessageBuilder) WithTimestamp(timestamp int64) JsonStatusMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonStatusMessageBuilder) WithIsCyclic(isCyclic bool) JsonStatusMessageBuilder {
	b.IsCyclic = isCyclic
	return b
}

func (b *_JsonStatusMessageBuilder) WithStatus(status PubSubState) JsonStatusMessageBuilder {
	b.Status = status
	return b
}

func (b *_JsonStatusMessageBuilder) WithNextReportTime(nextReportTime int64) JsonStatusMessageBuilder {
	b.NextReportTime = nextReportTime
	return b
}

func (b *_JsonStatusMessageBuilder) Build() (JsonStatusMessage, error) {
	if b.MessageId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'messageId' not set"))
	}
	if b.MessageType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'messageType' not set"))
	}
	if b.PublisherId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'publisherId' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._JsonStatusMessage.deepCopy(), nil
}

func (b *_JsonStatusMessageBuilder) MustBuild() JsonStatusMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonStatusMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonStatusMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonStatusMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonStatusMessageBuilder().(*_JsonStatusMessageBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateJsonStatusMessageBuilder creates a JsonStatusMessageBuilder
func (b *_JsonStatusMessage) CreateJsonStatusMessageBuilder() JsonStatusMessageBuilder {
	if b == nil {
		return NewJsonStatusMessageBuilder()
	}
	return &_JsonStatusMessageBuilder{_JsonStatusMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonStatusMessage) GetExtensionId() int32 {
	return int32(19318)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonStatusMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonStatusMessage) GetMessageId() PascalString {
	return m.MessageId
}

func (m *_JsonStatusMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonStatusMessage) GetPublisherId() PascalString {
	return m.PublisherId
}

func (m *_JsonStatusMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonStatusMessage) GetIsCyclic() bool {
	return m.IsCyclic
}

func (m *_JsonStatusMessage) GetStatus() PubSubState {
	return m.Status
}

func (m *_JsonStatusMessage) GetNextReportTime() int64 {
	return m.NextReportTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonStatusMessage(structType any) JsonStatusMessage {
	if casted, ok := structType.(JsonStatusMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonStatusMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonStatusMessage) GetTypeName() string {
	return "JsonStatusMessage"
}

func (m *_JsonStatusMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (messageId)
	lengthInBits += m.MessageId.GetLengthInBits(ctx)

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += 64

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (isCyclic)
	lengthInBits += 1

	// Simple field (status)
	lengthInBits += 32

	// Simple field (nextReportTime)
	lengthInBits += 64

	return lengthInBits
}

func (m *_JsonStatusMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonStatusMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonStatusMessage JsonStatusMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonStatusMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonStatusMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	messageId, err := ReadSimpleField[PascalString](ctx, "messageId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageId' field"))
	}
	m.MessageId = messageId

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	publisherId, err := ReadSimpleField[PascalString](ctx, "publisherId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	isCyclic, err := ReadSimpleField(ctx, "isCyclic", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isCyclic' field"))
	}
	m.IsCyclic = isCyclic

	status, err := ReadEnumField[PubSubState](ctx, "status", "PubSubState", ReadEnum(PubSubStateByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'status' field"))
	}
	m.Status = status

	nextReportTime, err := ReadSimpleField(ctx, "nextReportTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'nextReportTime' field"))
	}
	m.NextReportTime = nextReportTime

	if closeErr := readBuffer.CloseContext("JsonStatusMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonStatusMessage")
	}

	return m, nil
}

func (m *_JsonStatusMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonStatusMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonStatusMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonStatusMessage")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageId", m.GetMessageId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "publisherId", m.GetPublisherId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "isCyclic", m.GetIsCyclic(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'isCyclic' field")
		}

		if err := WriteSimpleEnumField[PubSubState](ctx, "status", "PubSubState", m.GetStatus(), WriteEnum[PubSubState, uint32](PubSubState.GetValue, PubSubState.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'status' field")
		}

		if err := WriteSimpleField[int64](ctx, "nextReportTime", m.GetNextReportTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'nextReportTime' field")
		}

		if popErr := writeBuffer.PopContext("JsonStatusMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonStatusMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonStatusMessage) IsJsonStatusMessage() {}

func (m *_JsonStatusMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonStatusMessage) deepCopy() *_JsonStatusMessage {
	if m == nil {
		return nil
	}
	_JsonStatusMessageCopy := &_JsonStatusMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.MessageId),
		utils.DeepCopy[PascalString](m.MessageType),
		utils.DeepCopy[PascalString](m.PublisherId),
		m.Timestamp,
		m.IsCyclic,
		m.Status,
		m.NextReportTime,
		m.reservedField0,
	}
	_JsonStatusMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonStatusMessageCopy
}

func (m *_JsonStatusMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
