/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;

public class ResponseUtil {
    public static Property createPrimitive(String name, String type, Object value) {
        return new Property(type, name, ValueType.PRIMITIVE, value);
    }

    public static Property createPrimitiveCollection(String name, Object ... values) {
        return new Property(null, name, ValueType.COLLECTION_PRIMITIVE, Arrays.asList(values));
    }

    public static Property createComplex(String name, String type, Property ... properties) {
        ComplexValue complexValue = new ComplexValue();
        for (Property property : properties) {
            complexValue.getValue().add(property);
        }
        return new Property(type, name, ValueType.COMPLEX, (Object)complexValue);
    }

    public static Property createComplexCollection(String name, String type, List<Property> ... propertiesList) {
        ArrayList<ComplexValue> complexCollection = new ArrayList<ComplexValue>();
        for (List<Property> properties : propertiesList) {
            ComplexValue complexValue = new ComplexValue();
            complexValue.getValue().addAll(properties);
            complexCollection.add(complexValue);
        }
        return new Property(type, name, ValueType.COLLECTION_COMPLEX, complexCollection);
    }

    public static void setLink(Entity entity, String navigationPropertyName, Entity target) {
        Link link = entity.getNavigationLink(navigationPropertyName);
        if (link == null) {
            link = new Link();
            link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
            link.setTitle(navigationPropertyName);
            entity.getNavigationLinks().add(link);
        }
        link.setInlineEntity(target);
    }

    public static void setLinks(Entity entity, String navigationPropertyName, Entity ... targets) {
        Link link = entity.getNavigationLink(navigationPropertyName);
        if (link == null) {
            link = new Link();
            link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
            link.setTitle(navigationPropertyName);
            EntityCollection target = new EntityCollection();
            target.getEntities().addAll(Arrays.asList(targets));
            link.setInlineEntitySet(target);
            entity.getNavigationLinks().add(link);
        } else {
            link.getInlineEntitySet().getEntities().addAll(Arrays.asList(targets));
        }
    }
}

