/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.Map;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.FixedFormatSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class CountResponse
extends ServiceResponse {
    private final FixedFormatSerializer serializer;

    public static CountResponse getInstance(ServiceRequest request, ODataResponse response) {
        FixedFormatSerializer serializer = request.getOdata().createFixedFormatSerializer();
        return new CountResponse(request.getServiceMetaData(), serializer, response, request.getPreferences());
    }

    private CountResponse(ServiceMetadata metadata, FixedFormatSerializer serializer, ODataResponse response, Map<String, String> preferences) {
        super(metadata, response, preferences);
        this.serializer = serializer;
    }

    public void writeCount(int count) throws SerializerException {
        assert (!this.isClosed());
        this.response.setContent(this.serializer.count(Integer.valueOf(count)));
        this.writeOK(ContentType.TEXT_PLAIN);
        this.close();
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataLibraryException, ODataApplicationException {
        visitor.visit(this);
    }
}

