/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceActionImpl;
import org.apache.olingo.server.core.uri.UriResourceComplexPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceFunctionImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourcePrimitivePropertyImpl;
import org.apache.olingo.server.core.uri.parser.ParserHelper;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.queryoption.SelectItemImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectOptionImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class SelectParser {
    private final Edm edm;

    public SelectParser(Edm edm) {
        this.edm = edm;
    }

    public SelectOption parse(UriTokenizer tokenizer, EdmStructuredType referencedType, boolean referencedIsCollection) throws UriParserException, UriValidationException {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        do {
            SelectItem item = this.parseItem(tokenizer, referencedType, referencedIsCollection);
            selectItems.add(item);
        } while (tokenizer.next(UriTokenizer.TokenKind.COMMA));
        return new SelectOptionImpl().setSelectItems(selectItems);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SelectItem parseItem(UriTokenizer tokenizer, EdmStructuredType referencedType, boolean referencedIsCollection) throws UriParserException {
        SelectItemImpl item = new SelectItemImpl();
        if (tokenizer.next(UriTokenizer.TokenKind.STAR)) {
            item.setStar(true);
            return item;
        } else if (tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
            FullQualifiedName allOperationsInSchema = this.parseAllOperationsInSchema(tokenizer);
            if (allOperationsInSchema != null) {
                item.addAllOperationsInSchema(allOperationsInSchema);
                return item;
            } else {
                this.ensureReferencedTypeNotNull(referencedType);
                FullQualifiedName qualifiedName = new FullQualifiedName(tokenizer.getText());
                EdmEntityType type = this.edm.getEntityType(qualifiedName);
                if (type == null) {
                    type = this.edm.getComplexType(qualifiedName);
                }
                if (type == null) {
                    item.setResourcePath((UriInfoResource)new UriInfoImpl().setKind(UriInfoKind.resource).addResourcePart((UriResource)this.parseBoundOperation(tokenizer, qualifiedName, referencedType, referencedIsCollection)));
                    return item;
                } else {
                    if (!type.compatibleTo((EdmType)referencedType)) throw new UriParserSemanticException("The type cast is not compatible.", UriParserSemanticException.MessageKeys.INCOMPATIBLE_TYPE_FILTER, type.getName());
                    item.setTypeFilter((EdmType)type);
                    if (!tokenizer.next(UriTokenizer.TokenKind.SLASH)) return item;
                    ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
                    UriInfoImpl resource = new UriInfoImpl().setKind(UriInfoKind.resource);
                    this.addSelectPath(tokenizer, (EdmStructuredType)type, resource);
                    item.setResourcePath((UriInfoResource)resource);
                }
            }
            return item;
        } else {
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
            FullQualifiedName allOperationsInSchema = this.parseAllOperationsInSchema(tokenizer);
            if (allOperationsInSchema != null) {
                item.addAllOperationsInSchema(allOperationsInSchema);
                return item;
            } else {
                this.ensureReferencedTypeNotNull(referencedType);
                UriInfoImpl resource = new UriInfoImpl().setKind(UriInfoKind.resource);
                this.addSelectPath(tokenizer, referencedType, resource);
                item.setResourcePath((UriInfoResource)resource);
            }
        }
        return item;
    }

    private FullQualifiedName parseAllOperationsInSchema(UriTokenizer tokenizer) throws UriParserException {
        String namespace = tokenizer.getText();
        if (tokenizer.next(UriTokenizer.TokenKind.DOT)) {
            if (tokenizer.next(UriTokenizer.TokenKind.STAR)) {
                if (this.edm.getEntityContainer(new FullQualifiedName(namespace, this.edm.getEntityContainer().getName())) == null) {
                    throw new UriParserSemanticException("Wrong namespace '" + namespace + "'.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, namespace);
                }
                return new FullQualifiedName(namespace, tokenizer.getText());
            }
            throw new UriParserSemanticException("Expected star after dot.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, "");
        }
        return null;
    }

    private void ensureReferencedTypeNotNull(EdmStructuredType referencedType) throws UriParserException {
        if (referencedType == null) {
            throw new UriParserSemanticException("The referenced part is not typed.", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "select");
        }
    }

    private UriResourcePartTyped parseBoundOperation(UriTokenizer tokenizer, FullQualifiedName qualifiedName, EdmStructuredType referencedType, boolean referencedIsCollection) throws UriParserException {
        EdmAction boundAction = this.edm.getBoundAction(qualifiedName, referencedType.getFullQualifiedName(), Boolean.valueOf(referencedIsCollection));
        if (boundAction == null) {
            List<String> parameterNames = this.parseFunctionParameterNames(tokenizer);
            EdmFunction boundFunction = this.edm.getBoundFunction(qualifiedName, referencedType.getFullQualifiedName(), Boolean.valueOf(referencedIsCollection), parameterNames);
            if (boundFunction == null) {
                throw new UriParserSemanticException("Function not found.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, qualifiedName.getFullQualifiedNameAsString());
            }
            return new UriResourceFunctionImpl(null, boundFunction, null);
        }
        return new UriResourceActionImpl(boundAction);
    }

    private List<String> parseFunctionParameterNames(UriTokenizer tokenizer) throws UriParserException {
        ArrayList<String> names = new ArrayList<String>();
        if (tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
            do {
                ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
                names.add(tokenizer.getText());
            } while (tokenizer.next(UriTokenizer.TokenKind.COMMA));
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.CLOSE);
        }
        return names;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addSelectPath(UriTokenizer tokenizer, EdmStructuredType referencedType, UriInfoImpl resource) throws UriParserException {
        String name = tokenizer.getText();
        EdmProperty property = referencedType.getStructuralProperty(name);
        if (property == null) {
            EdmNavigationProperty navigationProperty = referencedType.getNavigationProperty(name);
            if (navigationProperty == null) {
                throw new UriParserSemanticException("Selected property not found.", UriParserSemanticException.MessageKeys.EXPRESSION_PROPERTY_NOT_IN_TYPE, referencedType.getName(), name);
            }
            resource.addResourcePart(new UriResourceNavigationPropertyImpl(navigationProperty));
            return;
        } else if (property.isPrimitive() || property.getType().getKind() == EdmTypeKind.ENUM || property.getType().getKind() == EdmTypeKind.DEFINITION) {
            resource.addResourcePart(new UriResourcePrimitivePropertyImpl(property));
            return;
        } else {
            UriResourceComplexPropertyImpl complexPart = new UriResourceComplexPropertyImpl(property);
            resource.addResourcePart(complexPart);
            if (!tokenizer.next(UriTokenizer.TokenKind.SLASH)) return;
            if (tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
                FullQualifiedName qualifiedName = new FullQualifiedName(tokenizer.getText());
                EdmComplexType type = this.edm.getComplexType(qualifiedName);
                if (type == null) {
                    throw new UriParserSemanticException("Type not found.", UriParserSemanticException.MessageKeys.UNKNOWN_TYPE, qualifiedName.getFullQualifiedNameAsString());
                }
                if (!type.compatibleTo(property.getType())) throw new UriParserSemanticException("The type cast is not compatible.", UriParserSemanticException.MessageKeys.INCOMPATIBLE_TYPE_FILTER, type.getName());
                complexPart.setTypeFilter((EdmStructuredType)type);
                if (!tokenizer.next(UriTokenizer.TokenKind.SLASH)) return;
                if (!tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) throw new UriParserSemanticException("Unknown part after '/'.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, "");
                this.addSelectPath(tokenizer, (EdmStructuredType)type, resource);
                return;
            } else if (tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
                this.addSelectPath(tokenizer, (EdmStructuredType)property.getType(), resource);
                return;
            } else {
                if (!tokenizer.next(UriTokenizer.TokenKind.SLASH)) throw new UriParserSemanticException("Unknown part after '/'.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, "");
                throw new UriParserSyntaxException("Illegal $select expression.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
            }
        }
    }
}

