/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import java.lang.ref.SoftReference;
import jpt.sun.tools.javac.util.ArrayUtils;
import jpt.sun.tools.javac.util.Convert;
import jpt.sun.tools.javac.util.InvalidUtfException;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Names;
import jpt.sun.tools.javac.util.Utf8NameTable;

public class SharedNameTable
extends Utf8NameTable {
    private static List<SoftReference<SharedNameTable>> freelist = List.nil();
    private NameImpl[] hashes;
    public byte[] bytes;
    private int hashMask;
    private int nc = 0;

    public static synchronized SharedNameTable create(Names names) {
        while (freelist.nonEmpty()) {
            SharedNameTable t = (SharedNameTable)((SoftReference)SharedNameTable.freelist.head).get();
            freelist = SharedNameTable.freelist.tail;
            if (t == null) continue;
            return t;
        }
        return new SharedNameTable(names);
    }

    private static synchronized void dispose(SharedNameTable t) {
        freelist = freelist.prepend(new SoftReference<SharedNameTable>(t));
    }

    public SharedNameTable(Names names, int hashSize, int nameSize) {
        super(names);
        if (Integer.bitCount(hashSize) != 1) {
            throw new IllegalArgumentException();
        }
        this.hashMask = hashSize - 1;
        this.hashes = new NameImpl[hashSize];
        this.bytes = new byte[nameSize];
    }

    public SharedNameTable(Names names) {
        this(names, 32768, 131072);
    }

    @Override
    public Name fromChars(char[] cs, int start, int len) {
        int nc = this.nc;
        this.bytes = ArrayUtils.ensureCapacity(this.bytes, nc + len * 3);
        byte[] bytes = this.bytes;
        int nbytes = Convert.chars2utf(cs, start, bytes, nc, len) - nc;
        int h = SharedNameTable.hashValue(bytes, nc, nbytes) & this.hashMask;
        NameImpl n = this.hashes[h];
        while (!(n == null || n.getByteLength() == nbytes && SharedNameTable.equals(bytes, n.index, bytes, nc, nbytes))) {
            n = n.next;
        }
        if (n == null) {
            n = this.addName(nc, nbytes, h);
        }
        return n;
    }

    @Override
    public Name fromUtf(byte[] cs, int start, int len, Convert.Validation validation) throws InvalidUtfException {
        if (validation != Convert.Validation.NONE) {
            Convert.utfValidate(cs, start, len, validation);
        }
        int h = SharedNameTable.hashValue(cs, start, len) & this.hashMask;
        NameImpl n = this.hashes[h];
        byte[] names = this.bytes;
        while (!(n == null || n.getByteLength() == len && SharedNameTable.equals(names, n.index, cs, start, len))) {
            n = n.next;
        }
        if (n == null) {
            names = this.bytes = ArrayUtils.ensureCapacity(names, this.nc + len);
            System.arraycopy(cs, start, names, this.nc, len);
            n = this.addName(this.nc, len, h);
        }
        return n;
    }

    private NameImpl addName(int index, int len, int hash) {
        NameImpl name;
        this.hashes[hash] = name = new NameImpl(this, index, len, this.hashes[hash]);
        this.nc = index + Math.max(len, 1);
        return name;
    }

    @Override
    public void dispose() {
        SharedNameTable.dispose(this);
    }

    static final class NameImpl
    extends Utf8NameTable.NameImpl {
        final NameImpl next;
        final int index;
        final int length;

        NameImpl(SharedNameTable table, int index, int length, NameImpl next) {
            super(table);
            this.index = index;
            this.length = length;
            this.next = next;
        }

        @Override
        protected byte[] getByteData() {
            return ((SharedNameTable)this.table).bytes;
        }

        @Override
        protected int getByteOffset() {
            return this.index;
        }

        @Override
        protected int getByteLength() {
            return this.length;
        }

        @Override
        protected int getNameIndex() {
            return this.index;
        }
    }
}

