/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.core.api.security.Secured;
import org.apache.myfaces.extensions.cdi.core.impl.security.spi.EditableAccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.SecurityUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.security.spi.SecurityStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Dependent
public class DefaultSecurityStrategy
implements SecurityStrategy {
    private static final long serialVersionUID = -7999599690398948059L;
    @Inject
    private BeanManager beanManager;

    public Object execute(InvocationContext invocationContext) throws Exception {
        AccessDecisionVoterContext voterContext = (AccessDecisionVoterContext)CodiUtils.getContextualReferenceByClass((BeanManager)this.beanManager, AccessDecisionVoterContext.class, (boolean)true, (Annotation[])new Annotation[0]);
        Secured secured = null;
        List<Annotation> annotatedTypeMetadata = this.extractMetadata(invocationContext);
        for (Annotation annotation : annotatedTypeMetadata) {
            if (Secured.class.isAssignableFrom(annotation.annotationType())) {
                secured = (Secured)annotation;
                continue;
            }
            if (!(voterContext instanceof EditableAccessDecisionVoterContext)) continue;
            ((EditableAccessDecisionVoterContext)voterContext).addMetaData(annotation.annotationType().getName(), (Object)annotation);
        }
        if (secured != null) {
            Class[] voterClasses = secured.value();
            SecurityUtils.invokeVoters((InvocationContext)invocationContext, (BeanManager)this.beanManager, (AccessDecisionVoterContext)voterContext, Arrays.asList(voterClasses), (Class)secured.errorView());
        }
        return invocationContext.proceed();
    }

    private List<Annotation> extractMetadata(InvocationContext invocationContext) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Method method = invocationContext.getMethod();
        result.addAll(this.getAllAnnotations(method.getAnnotations()));
        result.addAll(this.getAllAnnotations(method.getDeclaringClass().getAnnotations()));
        return result;
    }

    private List<Annotation> getAllAnnotations(Annotation[] annotations) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            String annotationName = annotation.annotationType().getName();
            if (annotationName.startsWith("java.") || annotationName.startsWith("javax.")) continue;
            result.add(annotation);
            result.addAll(this.getAllAnnotations(annotation.annotationType().getAnnotations()));
        }
        return result;
    }
}

