/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.Nonbinding;
import org.apache.myfaces.extensions.cdi.core.api.Advanced;
import org.apache.myfaces.extensions.cdi.core.api.Aggregatable;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiConfig;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiCoreConfig;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.ConfiguredArtifactUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class CodiUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private CodiUtils() {
    }

    public static <T> T createNewInstanceOfBean(CreationalContext<T> creationalContext, Bean<T> bean) {
        return (T)bean.create(creationalContext);
    }

    public static <T> T getContextualReferenceByName(BeanManager beanManager, String beanName, Class<T> targetClass) {
        return CodiUtils.getContextualReferenceByName(beanManager, beanName, false, targetClass);
    }

    public static <T> T getContextualReferenceByName(BeanManager beanManager, String beanName, boolean optionalBeanAllowed, Class<T> targetClass) {
        Set foundBeans = beanManager.getBeans(beanName);
        if (foundBeans.size() >= 1) {
            Bean bean = beanManager.resolve(foundBeans);
            return CodiUtils.getContextualReference(beanManager, targetClass, bean);
        }
        if (!optionalBeanAllowed) {
            throw new IllegalStateException("No bean found for type: " + targetClass.getName() + " and name " + beanName);
        }
        return null;
    }

    public static <T> T getContextualReferenceByClass(Class<T> targetClass, Annotation ... qualifier) {
        return CodiUtils.getContextualReferenceByClass(BeanManagerProvider.getInstance().getBeanManager(), targetClass, qualifier);
    }

    public static <T> T getContextualReferenceByClass(BeanManager beanManager, Class<T> targetClass, Annotation ... qualifier) {
        return CodiUtils.getContextualReferenceByClass(beanManager, targetClass, false, qualifier);
    }

    public static <T> T getContextualReferenceByClass(Class<T> targetClass, boolean optionalBeanAllowed, Annotation ... qualifier) {
        return CodiUtils.getContextualReferenceByClass(BeanManagerProvider.getInstance().getBeanManager(), targetClass, optionalBeanAllowed, qualifier);
    }

    public static <T> T getContextualReferenceByClass(BeanManager beanManager, Class<T> targetClass, boolean optionalBeanAllowed, Annotation ... qualifier) {
        Bean<T> foundBean = CodiUtils.getOrCreateBeanByClass(beanManager, targetClass, optionalBeanAllowed, qualifier);
        if (foundBean != null) {
            return CodiUtils.getContextualReference(beanManager, targetClass, foundBean);
        }
        return null;
    }

    private static <T> Bean<T> getOrCreateBeanByClass(BeanManager beanManager, Class<T> targetClass, boolean optionalBeanAllowed, Annotation ... qualifier) {
        Set foundBeans = beanManager.getBeans(targetClass, qualifier);
        if (foundBeans.size() >= 1) {
            return beanManager.resolve(foundBeans);
        }
        if (!optionalBeanAllowed) {
            throw new IllegalStateException("No bean found for type: " + targetClass.getName());
        }
        return null;
    }

    public static <T> T getContextualReference(BeanManager beanManager, Type t, Bean<T> bean) {
        CreationalContext cc = beanManager.createCreationalContext(bean);
        return (T)beanManager.getReference(bean, t, cc);
    }

    public static <T> T injectFields(T instance) {
        CodiCoreConfig codiCoreConfig = CodiUtils.getContextualReferenceByClass(CodiCoreConfig.class, new Annotation[0]);
        return CodiUtils.injectFields(instance, codiCoreConfig.isAdvancedQualifierRequiredForDependencyInjection());
    }

    public static <T> T injectFields(T instance, boolean requiresAdvancedQualifier) {
        if (instance == null) {
            return null;
        }
        if (requiresAdvancedQualifier && instance.getClass().isAnnotationPresent(Advanced.class)) {
            return CodiUtils.tryToInjectFields(instance);
        }
        if (!requiresAdvancedQualifier) {
            return CodiUtils.tryToInjectFields(instance);
        }
        return instance;
    }

    private static <T> T tryToInjectFields(T instance) {
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        Object foundBean = CodiUtils.getContextualReferenceByClass(beanManager, instance.getClass(), true, new Annotation[0]);
        if (foundBean != null) {
            return (T)foundBean;
        }
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(instance.getClass());
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
        injectionTarget.inject(instance, creationalContext);
        return instance;
    }

    public static boolean isQualifierEqual(Annotation qualifier1, Annotation qualifier2) {
        Class<? extends Annotation> qualifier1AnnotationType = qualifier1.annotationType();
        if (qualifier1AnnotationType == null || !qualifier1AnnotationType.equals(qualifier2.annotationType())) {
            return false;
        }
        List<Method> bindingQualifierMethods = CodiUtils.getBindingQualifierMethods(qualifier1AnnotationType);
        for (Method method : bindingQualifierMethods) {
            Object value2;
            Object value1 = CodiUtils.callMethod(qualifier1, method);
            if (CodiUtils.checkEquality(value1, value2 = CodiUtils.callMethod(qualifier2, method))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkEquality(Object value1, Object value2) {
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        Class<?> valueClass = value1.getClass();
        if (!valueClass.equals(value2.getClass())) {
            return false;
        }
        if (valueClass.isPrimitive()) {
            return value1 == value2;
        }
        if (valueClass.isArray()) {
            Class<?> arrayType = valueClass.getComponentType();
            if (arrayType.isPrimitive()) {
                if (Long.TYPE == arrayType) {
                    return Arrays.equals((long[])value1, (long[])value2);
                }
                if (Integer.TYPE == arrayType) {
                    return Arrays.equals((int[])value1, (int[])value2);
                }
                if (Short.TYPE == arrayType) {
                    return Arrays.equals((short[])value1, (short[])value2);
                }
                if (Double.TYPE == arrayType) {
                    return Arrays.equals((double[])value1, (double[])value2);
                }
                if (Float.TYPE == arrayType) {
                    return Arrays.equals((float[])value1, (float[])value2);
                }
                if (Boolean.TYPE == arrayType) {
                    return Arrays.equals((boolean[])value1, (boolean[])value2);
                }
                if (Byte.TYPE == arrayType) {
                    return Arrays.equals((byte[])value1, (byte[])value2);
                }
                if (Character.TYPE == arrayType) {
                    return Arrays.equals((char[])value1, (char[])value2);
                }
                return false;
            }
            return Arrays.equals((Object[])value1, (Object[])value2);
        }
        return value1.equals(value2);
    }

    private static Object callMethod(Object instance, Method method) {
        boolean accessible = method.isAccessible();
        try {
            if (!accessible) {
                method.setAccessible(true);
            }
            Object object = method.invoke(instance, EMPTY_OBJECT_ARRAY);
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnhandledException("Exception in method call : " + method.getName(), (Throwable)e);
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    private static List<Method> getBindingQualifierMethods(Class<? extends Annotation> qualifierAnnotationType) {
        Method[] qualifierMethods = qualifierAnnotationType.getDeclaredMethods();
        if (qualifierMethods.length > 0) {
            ArrayList<Method> bindingMethods = new ArrayList<Method>();
            for (Method qualifierMethod : qualifierMethods) {
                Annotation[] qualifierMethodAnnotations = qualifierMethod.getDeclaredAnnotations();
                if (qualifierMethodAnnotations.length > 0) {
                    boolean nonbinding = false;
                    for (Annotation qualifierMethodAnnotation : qualifierMethodAnnotations) {
                        if (!Nonbinding.class.equals(qualifierMethodAnnotation.annotationType())) continue;
                        nonbinding = true;
                        break;
                    }
                    if (nonbinding) continue;
                    bindingMethods.add(qualifierMethod);
                    continue;
                }
                bindingMethods.add(qualifierMethod);
            }
            return bindingMethods;
        }
        return Collections.emptyList();
    }

    public static <T extends Serializable> T lookupFromEnvironment(Class<T> targetType, T ... defaultImplementation) {
        return (T)CodiUtils.lookupFromEnvironment(targetType, null, defaultImplementation);
    }

    public static <T extends Serializable> T lookupFromEnvironment(Class<T> targetType, Aggregatable<T> aggregatable, T ... defaultImplementation) {
        return (T)CodiUtils.lookupFromEnvironment((String)targetType.getSimpleName(), targetType, aggregatable, defaultImplementation);
    }

    public static <T extends Serializable> T lookupFromEnvironment(String key, Class<T> targetType, T ... defaultImplementation) {
        return (T)CodiUtils.lookupFromEnvironment((String)key, targetType, null, defaultImplementation);
    }

    public static <T extends Serializable> T lookupConfigFromEnvironment(String key, Class<T> targetType, T defaultValue) {
        String result;
        if (key == null) {
            RuntimeException runtimeException = new RuntimeException();
            String baseKey = runtimeException.getStackTrace()[1].getMethodName();
            if (baseKey.startsWith("get")) {
                baseKey = baseKey.substring(3);
            } else if (baseKey.startsWith("is")) {
                baseKey = baseKey.substring(2);
            }
            baseKey = baseKey.substring(0, 1).toLowerCase() + baseKey.substring(1);
            String className = runtimeException.getStackTrace()[1].getClassName();
            Class configClass = ClassUtils.tryToLoadClassForName((String)className);
            className = configClass != null && CodiConfig.class.isAssignableFrom(configClass.getSuperclass()) ? configClass.getSuperclass().getSimpleName() : className.substring(className.lastIndexOf(".") + 1);
            String convertedKey = StringUtils.replaceUpperCaseCharactersWithUnderscores(baseKey);
            key = className + "." + convertedKey;
        }
        if ((result = (String)((Object)CodiUtils.lookupFromEnvironment((String)key, String.class, null, null))) == null) {
            return (T)(defaultValue != null ? defaultValue : null);
        }
        if (String.class.isAssignableFrom(targetType)) {
            return (T)((Serializable)targetType.cast(result));
        }
        if (Boolean.class.isAssignableFrom(targetType)) {
            return (T)((Serializable)targetType.cast(Boolean.parseBoolean(result)));
        }
        if (Integer.class.isAssignableFrom(targetType)) {
            return (T)((Serializable)targetType.cast(Integer.parseInt(result)));
        }
        throw new IllegalArgumentException(targetType.getName() + " isn't supported");
    }

    public static <T extends Serializable> T lookupFromEnvironment(String key, Class<T> targetType, Aggregatable<T> aggregatable, T ... defaultImplementation) {
        CodiUtils.checkDefaultImplementation(defaultImplementation);
        List<String> results = ConfiguredArtifactUtils.getCachedArtifact(key, targetType);
        if (results == null) {
            Object defaultInstance = null;
            if (defaultImplementation != null && defaultImplementation.length == 1) {
                defaultInstance = defaultImplementation[0];
            }
            results = ConfiguredArtifactUtils.resolveFromEnvironment(key, targetType, aggregatable != null, defaultInstance);
            if (String.class.isAssignableFrom(targetType)) {
                ConfiguredArtifactUtils.processConfiguredArtifact(key, results);
            } else {
                ConfiguredArtifactUtils.processFoundArtifact(key, targetType, results);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        if (aggregatable != null) {
            for (Serializable serializable : results) {
                aggregatable.add((Object)serializable);
            }
            return (T)((Serializable)aggregatable.create());
        }
        return (T)((Serializable)results.iterator().next());
    }

    private static void checkDefaultImplementation(Object[] defaultImplementation) {
        if (defaultImplementation != null && defaultImplementation.length > 1) {
            StringBuilder foundDefaultImplementations = new StringBuilder();
            for (Object o : defaultImplementation) {
                foundDefaultImplementations.append(o.getClass()).append("\n");
            }
            throw new IllegalStateException(defaultImplementation.length + " default implementations are provided. " + "CodiUtils#lookupFromEnvironment only allows one default implementation. Found implementations: " + foundDefaultImplementations.toString());
        }
    }

    public static boolean isCdiInitialized() {
        return BeanManagerProvider.isActive();
    }
}

