/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.Quota;

public class MetricConfig {
    private Quota quota = null;
    private int samples = 2;
    private long eventWindow = Long.MAX_VALUE;
    private long timeWindowMs = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private TimeUnit unit = TimeUnit.SECONDS;

    public Quota quota() {
        return this.quota;
    }

    public MetricConfig quota(Quota quota) {
        this.quota = quota;
        return this;
    }

    public long eventWindow() {
        return this.eventWindow;
    }

    public MetricConfig eventWindow(long window) {
        this.eventWindow = window;
        return this;
    }

    public long timeWindowMs() {
        return this.timeWindowMs;
    }

    public MetricConfig timeWindow(long window, TimeUnit unit) {
        this.timeWindowMs = TimeUnit.MILLISECONDS.convert(window, unit);
        return this;
    }

    public int samples() {
        return this.samples;
    }

    public MetricConfig samples(int samples) {
        if (samples < 1) {
            throw new IllegalArgumentException("The number of samples must be at least 1.");
        }
        this.samples = samples;
        return this;
    }

    public TimeUnit timeUnit() {
        return this.unit;
    }

    public MetricConfig timeUnit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }
}

