/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;

public class DocumentDictionary
implements Dictionary {
    protected final IndexReader reader;
    protected final String payloadField;
    private final String field;
    private final String weightField;

    public DocumentDictionary(IndexReader reader, String field, String weightField) {
        this.reader = reader;
        this.field = field;
        this.weightField = weightField;
        this.payloadField = null;
    }

    public DocumentDictionary(IndexReader reader, String field, String weightField, String payloadField) {
        this.reader = reader;
        this.field = field;
        this.weightField = weightField;
        this.payloadField = payloadField;
    }

    @Override
    public BytesRefIterator getWordsIterator() throws IOException {
        return new DocumentInputIterator(this.payloadField != null);
    }

    protected class DocumentInputIterator
    implements InputIterator {
        private final int docCount;
        private final Set<String> relevantFields;
        private final boolean hasPayloads;
        private final Bits liveDocs;
        private int currentDocId = -1;
        private long currentWeight;
        private BytesRef currentPayload;
        private Document doc;

        public DocumentInputIterator(boolean hasPayloads) throws IOException {
            this.docCount = DocumentDictionary.this.reader.maxDoc() - 1;
            this.hasPayloads = hasPayloads;
            this.currentPayload = null;
            this.liveDocs = MultiFields.getLiveDocs((IndexReader)DocumentDictionary.this.reader);
            this.relevantFields = this.getRelevantFields(DocumentDictionary.this.field, DocumentDictionary.this.weightField, DocumentDictionary.this.payloadField);
        }

        @Override
        public long weight() {
            return this.currentWeight;
        }

        public Comparator<BytesRef> getComparator() {
            return null;
        }

        public BytesRef next() throws IOException {
            while (this.currentDocId < this.docCount) {
                ++this.currentDocId;
                if (this.liveDocs != null && !this.liveDocs.get(this.currentDocId)) continue;
                this.doc = DocumentDictionary.this.reader.document(this.currentDocId, this.relevantFields);
                if (this.hasPayloads) {
                    IndexableField payload = this.doc.getField(DocumentDictionary.this.payloadField);
                    if (payload == null) {
                        throw new IllegalArgumentException(DocumentDictionary.this.payloadField + " does not exist");
                    }
                    if (payload.binaryValue() == null) {
                        throw new IllegalArgumentException(DocumentDictionary.this.payloadField + " does not have binary value");
                    }
                    this.currentPayload = payload.binaryValue();
                }
                this.currentWeight = this.getWeight(this.currentDocId);
                IndexableField fieldVal = this.doc.getField(DocumentDictionary.this.field);
                if (fieldVal == null) {
                    throw new IllegalArgumentException(DocumentDictionary.this.field + " does not exist");
                }
                if (fieldVal.stringValue() == null) {
                    throw new IllegalArgumentException(DocumentDictionary.this.field + " does not have string value");
                }
                return new BytesRef((CharSequence)fieldVal.stringValue());
            }
            return null;
        }

        @Override
        public BytesRef payload() {
            return this.currentPayload;
        }

        @Override
        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        protected long getWeight(int docId) {
            IndexableField weight = this.doc.getField(DocumentDictionary.this.weightField);
            if (weight == null) {
                throw new IllegalArgumentException(DocumentDictionary.this.weightField + " does not exist");
            }
            if (weight.numericValue() == null) {
                throw new IllegalArgumentException(DocumentDictionary.this.weightField + " does not have numeric value");
            }
            return weight.numericValue().longValue();
        }

        private Set<String> getRelevantFields(String ... fields) {
            HashSet<String> relevantFields = new HashSet<String>();
            for (String relevantField : fields) {
                if (relevantField == null) continue;
                relevantFields.add(relevantField);
            }
            return relevantFields;
        }
    }
}

