/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.hppc.hash.MurmurHash3;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.search.aggregations.bucket.AbstractHash;

public final class LongHash
extends AbstractHash {
    private LongArray keys;

    public LongHash(long capacity, PageCacheRecycler recycler) {
        this(capacity, 0.6f, recycler);
    }

    public LongHash(long capacity, float maxLoadFactor, PageCacheRecycler recycler) {
        super(capacity, maxLoadFactor, recycler);
        this.keys = BigArrays.newLongArray(this.capacity(), recycler, false);
    }

    private static long hash(long value) {
        return MurmurHash3.hash(value);
    }

    public long key(long index) {
        return this.keys.get(index);
    }

    public long find(long key) {
        long slot;
        long index = slot = LongHash.slot(LongHash.hash(key), this.mask);
        long id;
        while ((id = this.id(index)) != -1L && this.keys.get(index) != key) {
            index = LongHash.nextSlot(index, this.mask);
        }
        return id;
    }

    private long set(long key, long id) {
        long slot;
        assert (this.size < this.maxSize);
        long index = slot = LongHash.slot(LongHash.hash(key), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) {
                this.id(index, id);
                this.keys.set(index, key);
                ++this.size;
                return id;
            }
            if (this.keys.get(index) == key) {
                return -1L - curId;
            }
            index = LongHash.nextSlot(index, this.mask);
        }
    }

    private void reset(long key, long id) {
        long slot;
        long index = slot = LongHash.slot(LongHash.hash(key), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) break;
            assert (this.keys.get(index) != key);
            index = LongHash.nextSlot(index, this.mask);
        }
        this.id(index, id);
        this.keys.set(index, key);
    }

    public long add(long key) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key, this.size);
    }

    @Override
    protected void resizeKeys(long capacity) {
        this.keys = BigArrays.resize(this.keys, capacity);
    }

    @Override
    protected void removeAndAdd(long index, long id) {
        long key = this.keys.set(index, 0L);
        this.reset(key, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release() {
        boolean success = false;
        try {
            super.release();
            success = true;
        }
        catch (Throwable throwable) {
            Releasables.release(success, this.keys);
            throw throwable;
        }
        Releasables.release(success, this.keys);
        return true;
    }
}

