/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.script;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.script.ScriptScoreFunctionParser;

public class ScriptScoreFunctionBuilder
implements ScoreFunctionBuilder {
    private String script;
    private String lang;
    private Map<String, Object> params = null;

    public ScriptScoreFunctionBuilder script(String script) {
        this.script = script;
        return this;
    }

    public ScriptScoreFunctionBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public ScriptScoreFunctionBuilder params(Map<String, Object> params) {
        if (this.params == null) {
            this.params = params;
        } else {
            this.params.putAll(params);
        }
        return this;
    }

    public ScriptScoreFunctionBuilder param(String key, Object value) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(key, value);
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field("script", this.script);
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.params != null) {
            builder.field("params", this.params);
        }
        return builder.endObject();
    }

    @Override
    public String getName() {
        return ScriptScoreFunctionParser.NAMES[0];
    }
}

