/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericDateAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class DateFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "date";
    protected FormatDateTimeFormatter dateTimeFormatter;
    private final boolean roundCeil;
    private final DateMathParser dateMathParser;
    private String nullValue;
    protected final TimeUnit timeUnit;

    public static Locale parseLocale(String locale) {
        String[] parts = locale.split("_", -1);
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                if ("ROOT".equalsIgnoreCase(parts[0])) {
                    return Locale.ROOT;
                }
                return new Locale(parts[0]);
            }
        }
        throw new ElasticsearchIllegalArgumentException("Can't parse locale: [" + locale + "]");
    }

    protected DateFieldMapper(FieldMapper.Names names, FormatDateTimeFormatter dateTimeFormatter, int precisionStep, float boost, FieldType fieldType, Boolean docValues, String nullValue, TimeUnit timeUnit, boolean roundCeil, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo) {
        super(names, precisionStep, boost, fieldType, docValues, ignoreMalformed, coerce, new NamedAnalyzer("_date/" + precisionStep, new NumericDateAnalyzer(precisionStep, dateTimeFormatter.parser())), new NamedAnalyzer("_date/max", new NumericDateAnalyzer(Integer.MAX_VALUE, dateTimeFormatter.parser())), postingsProvider, docValuesProvider, similarity, normsLoading, fieldDataSettings, indexSettings, multiFields, copyTo);
        this.dateTimeFormatter = dateTimeFormatter;
        this.nullValue = nullValue;
        this.timeUnit = timeUnit;
        this.roundCeil = roundCeil;
        this.dateMathParser = new DateMathParser(dateTimeFormatter, timeUnit);
    }

    public FormatDateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public DateMathParser dateMathParser() {
        return this.dateMathParser;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("long");
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return Numbers.bytesToLong((BytesRef)value);
        }
        return this.parseStringValue(value.toString());
    }

    @Override
    public Object valueForSearch(Object value) {
        if (value instanceof String) {
            return value;
        }
        Long val = this.value(value);
        if (val == null) {
            return null;
        }
        return this.dateTimeFormatter.printer().print(val);
    }

    @Override
    public BytesRef indexedValueForSearch(Object value) {
        BytesRef bytesRef = new BytesRef();
        NumericUtils.longToPrefixCoded((long)this.parseValue(value), (int)0, (BytesRef)bytesRef);
        return bytesRef;
    }

    private long parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return this.dateTimeFormatter.parser().parseMillis(((BytesRef)value).utf8ToString());
        }
        return this.dateTimeFormatter.parser().parseMillis(value.toString());
    }

    private String convertToString(Object value) {
        if (value instanceof BytesRef) {
            return ((BytesRef)value).utf8ToString();
        }
        return value.toString();
    }

    @Override
    public Query fuzzyQuery(String value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        long iSim;
        long iValue = this.dateMathParser.parse(value, System.currentTimeMillis());
        try {
            iSim = fuzziness.asTimeValue().millis();
        }
        catch (Exception e) {
            iSim = fuzziness.asLong();
        }
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        long lValue = this.parseToMilliseconds(value, context);
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)lValue, (Long)lValue, (boolean)true, (boolean)true);
    }

    public long parseToMilliseconds(Object value, @Nullable QueryParseContext context) {
        return this.parseToMilliseconds(value, context, false);
    }

    public long parseToMilliseconds(Object value, @Nullable QueryParseContext context, boolean includeUpper) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return includeUpper && this.roundCeil ? this.dateMathParser.parseRoundCeil(this.convertToString(value), now) : this.dateMathParser.parse(this.convertToString(value), now);
    }

    public long parseToMilliseconds(String value, @Nullable QueryParseContext context, boolean includeUpper) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return includeUpper && this.roundCeil ? this.dateMathParser.parseRoundCeil(value, now) : this.dateMathParser.parse(value, now);
    }

    @Override
    public Filter termFilter(Object value, @Nullable QueryParseContext context) {
        long lValue = this.parseToMilliseconds(value, context);
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)lValue, (Long)lValue, (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(this.parseToMilliseconds(lowerTerm, context))), upperTerm == null ? null : Long.valueOf(this.parseToMilliseconds(upperTerm, context, includeUpper)), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return this.rangeFilter(lowerTerm, upperTerm, includeLower, includeUpper, context, false);
    }

    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context, boolean explicitCaching) {
        String value;
        boolean cache = explicitCaching;
        Long lowerVal = null;
        Long upperVal = null;
        if (lowerTerm != null) {
            value = this.convertToString(lowerTerm);
            cache = explicitCaching || !this.hasNowExpressionWithNoRounding(value);
            lowerVal = this.parseToMilliseconds(value, context, false);
        }
        if (upperTerm != null) {
            value = this.convertToString(upperTerm);
            cache = explicitCaching || !this.hasNowExpressionWithNoRounding(value);
            upperVal = this.parseToMilliseconds(value, context, includeUpper);
        }
        NumericRangeFilter filter = NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, lowerVal, upperVal, (boolean)includeLower, (boolean)includeUpper);
        if (!cache) {
            return NoCacheFilter.wrap((Filter)filter);
        }
        return filter;
    }

    @Override
    public Filter rangeFilter(IndexFieldDataService fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return this.rangeFilter(fieldData, lowerTerm, upperTerm, includeLower, includeUpper, context, false);
    }

    public Filter rangeFilter(IndexFieldDataService fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context, boolean explicitCaching) {
        String value;
        boolean cache = explicitCaching;
        Long lowerVal = null;
        Long upperVal = null;
        if (lowerTerm != null) {
            value = this.convertToString(lowerTerm);
            cache = explicitCaching || !this.hasNowExpressionWithNoRounding(value);
            lowerVal = this.parseToMilliseconds(value, context, false);
        }
        if (upperTerm != null) {
            value = this.convertToString(upperTerm);
            cache = explicitCaching || !this.hasNowExpressionWithNoRounding(value);
            upperVal = this.parseToMilliseconds(value, context, includeUpper);
        }
        NumericRangeFieldDataFilter<Long> filter = NumericRangeFieldDataFilter.newLongRange((IndexNumericFieldData)fieldData.getForField(this), lowerVal, upperVal, includeLower, includeUpper);
        if (!cache) {
            return NoCacheFilter.wrap(filter);
        }
        return filter;
    }

    private boolean hasNowExpressionWithNoRounding(String value) {
        int index = value.indexOf("now");
        if (index != -1) {
            if (value.length() == 3) {
                return true;
            }
            int indexOfPotentialRounding = index + 3;
            if (indexOfPotentialRounding >= value.length()) {
                return true;
            }
            do {
                char potentialRoundingChar;
                if ((potentialRoundingChar = value.charAt(indexOfPotentialRounding++)) == '/') {
                    return false;
                }
                if (potentialRoundingChar != ' ') continue;
                return true;
            } while (indexOfPotentialRounding < value.length());
            return true;
        }
        return false;
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        long value = this.parseStringValue(this.nullValue);
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)value, (Long)value, (boolean)true, (boolean)true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        String dateAsString = null;
        Long value = null;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue instanceof Number) {
                value = ((Number)externalValue).longValue();
            } else {
                dateAsString = (String)externalValue;
                if (dateAsString == null) {
                    dateAsString = this.nullValue;
                }
            }
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                dateAsString = this.nullValue;
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                value = parser.longValue((Boolean)this.coerce.value());
            } else if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (token == XContentParser.Token.VALUE_NULL) {
                            dateAsString = this.nullValue;
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            value = parser.longValue((Boolean)this.coerce.value());
                            continue;
                        }
                        dateAsString = parser.text();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticsearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                dateAsString = parser.text();
            }
        }
        if (dateAsString != null) {
            assert (value == null);
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.names.fullName(), dateAsString, boost);
            }
            value = this.parseStringValue(dateAsString);
        }
        if (value != null) {
            if (this.fieldType.indexed() || this.fieldType.stored()) {
                LongFieldMapper.CustomLongNumericField field = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value, this.fieldType);
                field.setBoost(boost);
                fields.add(field);
            }
            if (this.hasDocValues()) {
                this.addDocValue(context, value);
            }
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((DateFieldMapper)mergeWith).nullValue;
            this.dateTimeFormatter = ((DateFieldMapper)mergeWith).dateTimeFormatter;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        builder.field("format", this.dateTimeFormatter.format());
        if (includeDefaults || this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
        if (includeDefaults || this.timeUnit != Defaults.TIME_UNIT) {
            builder.field("numeric_resolution", this.timeUnit.name().toLowerCase(Locale.ROOT));
        }
        if (this.dateTimeFormatter.locale() != null && this.dateTimeFormatter.locale() != Locale.ROOT) {
            builder.field("locale", (Object)this.dateTimeFormatter.locale());
        } else if (includeDefaults) {
            if (this.dateTimeFormatter.locale() == null) {
                builder.field("locale", (Object)Locale.ROOT);
            } else {
                builder.field("locale", (Object)this.dateTimeFormatter.locale());
            }
        }
    }

    private long parseStringValue(String value) {
        try {
            return this.dateTimeFormatter.parser().parseMillis(value);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new MapperParsingException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number with locale [" + this.dateTimeFormatter.locale() + "]", e);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.dateField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(propNode.toString());
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propName, propNode));
                    continue;
                }
                if (propName.equals("numeric_resolution")) {
                    builder.timeUnit(TimeUnit.valueOf(propNode.toString().toUpperCase(Locale.ROOT)));
                    continue;
                }
                if (!propName.equals("locale")) continue;
                builder.locale(DateFieldMapper.parseLocale(propNode.toString()));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, DateFieldMapper> {
        protected TimeUnit timeUnit = Defaults.TIME_UNIT;
        protected String nullValue = Defaults.NULL_VALUE;
        protected FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;
        private Locale locale;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            boolean roundCeil = true;
            if (context.indexSettings() != null) {
                Settings settings = context.indexSettings();
                roundCeil = settings.getAsBoolean("index.mapping.date.round_ceil", settings.getAsBoolean("index.mapping.date.parse_upper_inclusive", (Boolean)true));
            }
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.boost == 1.0f);
            if (!this.locale.equals(this.dateTimeFormatter.locale())) {
                this.dateTimeFormatter = new FormatDateTimeFormatter(this.dateTimeFormatter.format(), this.dateTimeFormatter.parser(), this.dateTimeFormatter.printer(), this.locale);
            }
            DateFieldMapper fieldMapper = new DateFieldMapper(this.buildNames(context), this.dateTimeFormatter, this.precisionStep, this.boost, this.fieldType, this.docValues, this.nullValue, this.timeUnit, roundCeil, this.ignoreMalformed(context), this.coerce(context), this.postingsProvider, this.docValuesProvider, this.similarity, this.normsLoading, this.fieldDataSettings, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime", Locale.ROOT);
        public static final FieldType FIELD_TYPE = new FieldType(NumberFieldMapper.Defaults.FIELD_TYPE);
        public static final String NULL_VALUE;
        public static final TimeUnit TIME_UNIT;
        public static final boolean ROUND_CEIL = true;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
            TIME_UNIT = TimeUnit.MILLISECONDS;
        }
    }
}

