/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.hppc.AbstractFloatCollection;
import org.elasticsearch.common.hppc.AbstractIterator;
import org.elasticsearch.common.hppc.ArraySizingStrategy;
import org.elasticsearch.common.hppc.BoundedProportionalArraySizingStrategy;
import org.elasticsearch.common.hppc.FloatContainer;
import org.elasticsearch.common.hppc.FloatIndexedContainer;
import org.elasticsearch.common.hppc.Internals;
import org.elasticsearch.common.hppc.cursors.FloatCursor;
import org.elasticsearch.common.hppc.predicates.FloatPredicate;
import org.elasticsearch.common.hppc.procedures.FloatProcedure;

public class FloatArrayList
extends AbstractFloatCollection
implements FloatIndexedContainer,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    private static final Object EMPTY = new float[0];
    public float[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public FloatArrayList() {
        this(5);
    }

    public FloatArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public FloatArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public FloatArrayList(FloatContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(float e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(float e1, float e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(float[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(float ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(FloatContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (FloatCursor cursor : container) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        for (FloatCursor floatCursor : iterable) {
            this.add(floatCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, float e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public float get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public float set(int index, float e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        float v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public float remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        float v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0.0f;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, 0.0f);
    }

    @Override
    public int removeFirstOccurrence(float e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLastOccurrence(float e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAllOccurrences(float e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = 0.0f;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = 0.0f;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(float e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(float e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount >= bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            float[] newBuffer = new float[newSize];
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            }
            this.buffer = newBuffer;
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0.0f);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0.0f);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0.0f);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = (float[])EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public float[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public FloatArrayList clone() {
        try {
            FloatArrayList cloned = (FloatArrayList)super.clone();
            cloned.buffer = (float[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof FloatArrayList) {
                FloatArrayList other = (FloatArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof FloatIndexedContainer) {
                FloatIndexedContainer other = (FloatIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(float[] b1, float[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(FloatIndexedContainer b1, FloatIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            float o2;
            float o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends FloatProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        float[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(FloatPredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0.0f;
                    continue;
                }
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0.0f;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0.0f;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends FloatPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        float[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static FloatArrayList newInstance() {
        return new FloatArrayList();
    }

    public static FloatArrayList newInstanceWithCapacity(int initialCapacity) {
        return new FloatArrayList(initialCapacity);
    }

    public static FloatArrayList from(float ... elements) {
        FloatArrayList list = new FloatArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static FloatArrayList from(FloatContainer container) {
        return new FloatArrayList(container);
    }

    static final class ValueIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private final float[] buffer;
        private final int size;

        public ValueIterator(float[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected FloatCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (FloatCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

