/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentCoreReaders;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.CloseableThreadLocal;

public final class SegmentReader
extends AtomicReader {
    private final SegmentCommitInfo si;
    private final Bits liveDocs;
    private final int numDocs;
    final SegmentCoreReaders core;
    final SegmentDocValues segDocValues;
    final CloseableThreadLocal<Map<String, Object>> docValuesLocal = new CloseableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    final CloseableThreadLocal<Map<String, Bits>> docsWithFieldLocal = new CloseableThreadLocal<Map<String, Bits>>(){

        @Override
        protected Map<String, Bits> initialValue() {
            return new HashMap<String, Bits>();
        }
    };
    final Map<String, DocValuesProducer> dvProducers = new HashMap<String, DocValuesProducer>();
    final FieldInfos fieldInfos;
    private final List<Long> dvGens = new ArrayList<Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentReader(SegmentCommitInfo si, int termInfosIndexDivisor, IOContext context) throws IOException {
        this.si = si;
        this.fieldInfos = SegmentReader.readFieldInfos(si);
        this.core = new SegmentCoreReaders(this, si.info.dir, si, context, termInfosIndexDivisor);
        this.segDocValues = new SegmentDocValues();
        boolean success = false;
        Codec codec = si.info.getCodec();
        try {
            if (si.hasDeletions()) {
                this.liveDocs = codec.liveDocsFormat().readLiveDocs(this.directory(), si, IOContext.READONCE);
            } else {
                assert (si.getDelCount() == 0);
                this.liveDocs = null;
            }
            this.numDocs = si.info.getDocCount() - si.getDelCount();
            if (this.fieldInfos.hasDocValues()) {
                this.initDocValuesProducers(codec);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    SegmentReader(SegmentCommitInfo si, SegmentReader sr) throws IOException {
        this(si, sr, si.info.getCodec().liveDocsFormat().readLiveDocs(si.info.dir, si, IOContext.READONCE), si.info.getDocCount() - si.getDelCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentReader(SegmentCommitInfo si, SegmentReader sr, Bits liveDocs, int numDocs) throws IOException {
        this.si = si;
        this.liveDocs = liveDocs;
        this.numDocs = numDocs;
        this.core = sr.core;
        this.core.incRef();
        this.segDocValues = sr.segDocValues;
        boolean success = false;
        try {
            Codec codec = si.info.getCodec();
            this.fieldInfos = si.getFieldInfosGen() == -1L ? sr.fieldInfos : SegmentReader.readFieldInfos(si);
            if (this.fieldInfos.hasDocValues()) {
                this.initDocValuesProducers(codec);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    private void initDocValuesProducers(Codec codec) throws IOException {
        Directory dir = this.core.cfsReader != null ? this.core.cfsReader : this.si.info.dir;
        DocValuesFormat dvFormat = codec.docValuesFormat();
        Map<Long, List<FieldInfo>> genInfos = this.getGenInfos();
        for (Map.Entry<Long, List<FieldInfo>> e : genInfos.entrySet()) {
            Long gen = e.getKey();
            List<FieldInfo> infos = e.getValue();
            DocValuesProducer dvp = this.segDocValues.getDocValuesProducer(gen, this.si, IOContext.READ, dir, dvFormat, infos, this.getTermInfosIndexDivisor());
            for (FieldInfo fi : infos) {
                this.dvProducers.put(fi.name, dvp);
            }
        }
        this.dvGens.addAll(genInfos.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FieldInfos readFieldInfos(SegmentCommitInfo info) throws IOException {
        boolean closeDir;
        Directory dir;
        if (info.getFieldInfosGen() == -1L && info.info.getUseCompoundFile()) {
            dir = new CompoundFileDirectory(info.info.dir, IndexFileNames.segmentFileName(info.info.name, "", "cfs"), IOContext.READONCE, false);
            closeDir = true;
        } else {
            dir = info.info.dir;
            closeDir = false;
        }
        try {
            String segmentSuffix = info.getFieldInfosGen() == -1L ? "" : Long.toString(info.getFieldInfosGen(), 36);
            FieldInfos fieldInfos = info.info.getCodec().fieldInfosFormat().getFieldInfosReader().read(dir, info.info.name, segmentSuffix, IOContext.READONCE);
            return fieldInfos;
        }
        finally {
            if (closeDir) {
                dir.close();
            }
        }
    }

    private Map<Long, List<FieldInfo>> getGenInfos() {
        HashMap<Long, List<FieldInfo>> genInfos = new HashMap<Long, List<FieldInfo>>();
        for (FieldInfo fi : this.fieldInfos) {
            if (fi.getDocValuesType() == null) continue;
            long gen = fi.getDocValuesGen();
            ArrayList<FieldInfo> infos = (ArrayList<FieldInfo>)genInfos.get(gen);
            if (infos == null) {
                infos = new ArrayList<FieldInfo>();
                genInfos.put(gen, infos);
            }
            infos.add(fi);
        }
        return genInfos;
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.liveDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        try {
            this.core.decRef();
        }
        finally {
            this.dvProducers.clear();
            this.docValuesLocal.close();
            this.docsWithFieldLocal.close();
            this.segDocValues.decRef(this.dvGens);
        }
    }

    @Override
    public FieldInfos getFieldInfos() {
        this.ensureOpen();
        return this.fieldInfos;
    }

    public StoredFieldsReader getFieldsReader() {
        this.ensureOpen();
        return this.core.fieldsReaderLocal.get();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.checkBounds(docID);
        this.getFieldsReader().visitDocument(docID, visitor);
    }

    @Override
    public Fields fields() {
        this.ensureOpen();
        return this.core.fields;
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.si.info.getDocCount();
    }

    public TermVectorsReader getTermVectorsReader() {
        this.ensureOpen();
        return this.core.termVectorsLocal.get();
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        this.checkBounds(docID);
        return termVectorsReader.get(docID);
    }

    private void checkBounds(int docID) {
        if (docID < 0 || docID >= this.maxDoc()) {
            throw new IndexOutOfBoundsException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + docID + ")");
        }
    }

    public String toString() {
        return this.si.toString(this.si.info.dir, this.si.info.getDocCount() - this.numDocs - this.si.getDelCount());
    }

    public String getSegmentName() {
        return this.si.info.name;
    }

    public SegmentCommitInfo getSegmentInfo() {
        return this.si;
    }

    public Directory directory() {
        return this.si.info.dir;
    }

    @Override
    public Object getCoreCacheKey() {
        return this.core;
    }

    @Override
    public Object getCombinedCoreAndDeletesKey() {
        return this;
    }

    public int getTermInfosIndexDivisor() {
        return this.core.termsIndexDivisor;
    }

    private FieldInfo getDVField(String field, FieldInfo.DocValuesType type) {
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == null) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducers.get(field);
        assert (dvProducer != null);
        Map<String, Object> dvFields = this.docValuesLocal.get();
        NumericDocValues dvs = (NumericDocValues)dvFields.get(field);
        if (dvs == null) {
            dvs = dvProducer.getNumeric(fi);
            dvFields.put(field, dvs);
        }
        return dvs;
    }

    @Override
    public Bits getDocsWithField(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducers.get(field);
        assert (dvProducer != null);
        Map<String, Bits> dvFields = this.docsWithFieldLocal.get();
        Bits dvs = dvFields.get(field);
        if (dvs == null) {
            dvs = dvProducer.getDocsWithField(fi);
            dvFields.put(field, dvs);
        }
        return dvs;
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducers.get(field);
        assert (dvProducer != null);
        Map<String, Object> dvFields = this.docValuesLocal.get();
        BinaryDocValues dvs = (BinaryDocValues)dvFields.get(field);
        if (dvs == null) {
            dvs = dvProducer.getBinary(fi);
            dvFields.put(field, dvs);
        }
        return dvs;
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducers.get(field);
        assert (dvProducer != null);
        Map<String, Object> dvFields = this.docValuesLocal.get();
        SortedDocValues dvs = (SortedDocValues)dvFields.get(field);
        if (dvs == null) {
            dvs = dvProducer.getSorted(fi);
            dvFields.put(field, dvs);
        }
        return dvs;
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducers.get(field);
        assert (dvProducer != null);
        Map<String, Object> dvFields = this.docValuesLocal.get();
        SortedSetDocValues dvs = (SortedSetDocValues)dvFields.get(field);
        if (dvs == null) {
            dvs = dvProducer.getSortedSet(fi);
            dvFields.put(field, dvs);
        }
        return dvs;
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.core.getNormValues(fi);
    }

    public void addCoreClosedListener(CoreClosedListener listener) {
        this.ensureOpen();
        this.core.addCoreClosedListener(listener);
    }

    public void removeCoreClosedListener(CoreClosedListener listener) {
        this.ensureOpen();
        this.core.removeCoreClosedListener(listener);
    }

    public long ramBytesUsed() {
        this.ensureOpen();
        long ramBytesUsed = 0L;
        if (this.segDocValues != null) {
            ramBytesUsed += this.segDocValues.ramBytesUsed();
        }
        if (this.core != null) {
            ramBytesUsed += this.core.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    public static interface CoreClosedListener {
        public void onClose(Object var1);
    }
}

