/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.search.highlight.FastVectorHighlighter;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.Highlighters;
import org.elasticsearch.search.highlight.PlainHighlighter;
import org.elasticsearch.search.highlight.PostingsHighlighter;

public class HighlightModule
extends AbstractModule {
    private List<Class<? extends Highlighter>> highlighters = Lists.newArrayList();

    public HighlightModule() {
        this.registerHighlighter(FastVectorHighlighter.class);
        this.registerHighlighter(PlainHighlighter.class);
        this.registerHighlighter(PostingsHighlighter.class);
    }

    public void registerHighlighter(Class<? extends Highlighter> clazz) {
        this.highlighters.add(clazz);
    }

    @Override
    protected void configure() {
        Multibinder<Highlighter> multibinder = Multibinder.newSetBinder(this.binder(), Highlighter.class);
        for (Class<? extends Highlighter> highlighter : this.highlighters) {
            multibinder.addBinding().to(highlighter);
        }
        this.bind(Highlighters.class).asEagerSingleton();
    }
}

