/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;

public class InternalDateHistogram
extends InternalHistogram<Bucket>
implements DateHistogram {
    static final InternalAggregation.Type TYPE = new InternalAggregation.Type("date_histogram", "dhisto");
    static final Factory FACTORY = new Factory();
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalDateHistogram readResult(StreamInput in) throws IOException {
            InternalDateHistogram histogram = new InternalDateHistogram();
            histogram.readFrom(in);
            return histogram;
        }
    };

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalDateHistogram() {
    }

    InternalDateHistogram(String name, List<Bucket> buckets, InternalOrder order, long minDocCount, InternalHistogram.EmptyBucketInfo emptyBucketInfo, ValueFormatter formatter, boolean keyed) {
        super(name, buckets, order, minDocCount, emptyBucketInfo, formatter, keyed);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public DateHistogram.Bucket getBucketByKey(DateTime key) {
        return (DateHistogram.Bucket)this.getBucketByKey(key.getMillis());
    }

    @Override
    protected Bucket createBucket(long key, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
        return new Bucket(key, docCount, aggregations, formatter);
    }

    static class Factory
    extends InternalHistogram.Factory<Bucket> {
        private Factory() {
        }

        @Override
        public String type() {
            return TYPE.name();
        }

        public InternalDateHistogram create(String name, List<Bucket> buckets, InternalOrder order, long minDocCount, InternalHistogram.EmptyBucketInfo emptyBucketInfo, ValueFormatter formatter, boolean keyed) {
            return new InternalDateHistogram(name, buckets, order, minDocCount, emptyBucketInfo, formatter, keyed);
        }

        @Override
        public Bucket createBucket(long key, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            return new Bucket(key, docCount, aggregations, formatter);
        }
    }

    static class Bucket
    extends InternalHistogram.Bucket
    implements DateHistogram.Bucket {
        private final ValueFormatter formatter;

        Bucket(long key, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            super(key, docCount, aggregations);
            this.formatter = formatter;
        }

        @Override
        public String getKey() {
            return this.formatter != null ? this.formatter.format(this.key) : DateFieldMapper.Defaults.DATE_TIME_FORMATTER.printer().print(this.key);
        }

        @Override
        public DateTime getKeyAsDate() {
            return new DateTime(this.key);
        }
    }
}

