/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.BaseFuture;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;

public abstract class AdapterActionFuture<T, L>
extends BaseFuture<T>
implements ActionFuture<T>,
ActionListener<L> {
    private Throwable rootFailure;

    @Override
    public T actionGet() throws ElasticsearchException {
        try {
            return (T)this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElasticsearchIllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            throw AdapterActionFuture.rethrowExecutionException(e);
        }
    }

    @Override
    public T actionGet(String timeout) throws ElasticsearchException {
        return this.actionGet(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public T actionGet(long timeoutMillis) throws ElasticsearchException {
        return this.actionGet(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(TimeValue timeout) throws ElasticsearchException {
        return this.actionGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(long timeout, TimeUnit unit) throws ElasticsearchException {
        try {
            return (T)this.get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw new ElasticsearchTimeoutException(e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElasticsearchIllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            throw AdapterActionFuture.rethrowExecutionException(e);
        }
    }

    static ElasticsearchException rethrowExecutionException(ExecutionException e) {
        if (e.getCause() instanceof ElasticsearchException) {
            ElasticsearchException esEx = (ElasticsearchException)e.getCause();
            Throwable root = esEx.unwrapCause();
            if (root instanceof ElasticsearchException) {
                return (ElasticsearchException)root;
            }
            return new UncategorizedExecutionException("Failed execution", root);
        }
        return new UncategorizedExecutionException("Failed execution", e);
    }

    @Override
    public void onResponse(L result) {
        this.set(this.convert(result));
    }

    @Override
    public void onFailure(Throwable e) {
        this.setException(e);
    }

    protected abstract T convert(L var1);

    @Override
    public Throwable getRootFailure() {
        return this.rootFailure;
    }
}

