/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.internal.InternalClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class ExplainRequestBuilder
extends SingleShardOperationRequestBuilder<ExplainRequest, ExplainResponse, ExplainRequestBuilder> {
    private QuerySourceBuilder sourceBuilder;

    ExplainRequestBuilder(Client client) {
        super((InternalClient)client, new ExplainRequest());
    }

    public ExplainRequestBuilder(Client client, String index, String type, String id) {
        super((InternalClient)client, ((ExplainRequest)new ExplainRequest().index(index)).type(type).id(id));
    }

    public ExplainRequestBuilder setType(String type) {
        ((ExplainRequest)this.request()).type(type);
        return this;
    }

    public ExplainRequestBuilder setId(String id) {
        ((ExplainRequest)this.request()).id(id);
        return this;
    }

    public ExplainRequestBuilder setRouting(String routing) {
        ((ExplainRequest)this.request()).routing(routing);
        return this;
    }

    public ExplainRequestBuilder setParent(String parent) {
        ((ExplainRequest)this.request()).parent(parent);
        return this;
    }

    public ExplainRequestBuilder setPreference(String preference) {
        ((ExplainRequest)this.request()).preference(preference);
        return this;
    }

    public ExplainRequestBuilder setQuery(QueryBuilder query) {
        this.sourceBuilder().setQuery(query);
        return this;
    }

    public ExplainRequestBuilder setQuery(BytesReference query) {
        this.sourceBuilder().setQuery(query);
        return this;
    }

    public ExplainRequestBuilder setFields(String ... fields) {
        ((ExplainRequest)this.request).fields(fields);
        return this;
    }

    public ExplainRequestBuilder setFetchSource(boolean fetch) {
        FetchSourceContext context = ((ExplainRequest)this.request).fetchSourceContext();
        if (context == null) {
            ((ExplainRequest)this.request).fetchSourceContext(new FetchSourceContext(fetch));
        } else {
            context.fetchSource(fetch);
        }
        return this;
    }

    public ExplainRequestBuilder setFetchSource(@Nullable String include, @Nullable String exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        return this.setFetchSource(stringArray2, stringArray);
    }

    public ExplainRequestBuilder setFetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        FetchSourceContext context = ((ExplainRequest)this.request).fetchSourceContext();
        if (context == null) {
            ((ExplainRequest)this.request).fetchSourceContext(new FetchSourceContext(includes, excludes));
        } else {
            context.fetchSource(true);
            context.includes(includes);
            context.excludes(excludes);
        }
        return this;
    }

    public ExplainRequestBuilder setSource(BytesReference source, boolean unsafe) {
        ((ExplainRequest)this.request()).source(source, unsafe);
        return this;
    }

    public ExplainRequestBuilder operationThreaded(boolean threadedOperation) {
        ((ExplainRequest)this.request()).operationThreaded(threadedOperation);
        return this;
    }

    @Override
    protected void doExecute(ActionListener<ExplainResponse> listener) {
        if (this.sourceBuilder != null) {
            ((ExplainRequest)this.request).source(this.sourceBuilder);
        }
        ((Client)((Object)this.client)).explain((ExplainRequest)this.request, listener);
    }

    private QuerySourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new QuerySourceBuilder();
        }
        return this.sourceBuilder;
    }
}

