/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.DefaultConfigurationFactory;
import org.apache.logging.log4j.core.config.URIConfigurationFactory;
import org.apache.logging.log4j.core.config.composite.DefaultMergeStrategy;
import org.apache.logging.log4j.core.config.composite.MergeStrategy;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.impl.Log4jProvider;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import org.apache.logging.log4j.core.impl.internal.ReusableMessageFactory;
import org.apache.logging.log4j.core.lookup.ConfigurationStrSubstitutor;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.InterpolatorFactory;
import org.apache.logging.log4j.core.lookup.RuntimeStrSubstitutor;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.selector.BasicContextSelector;
import org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.time.Clock;
import org.apache.logging.log4j.core.time.NanoClock;
import org.apache.logging.log4j.core.time.internal.DummyNanoClock;
import org.apache.logging.log4j.core.util.DefaultShutdownCallbackRegistry;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.core.util.internal.SystemUtils;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.kit.recycler.RecyclerFactoryProvider;
import org.apache.logging.log4j.kit.recycler.RecyclerProperties;
import org.apache.logging.log4j.message.DefaultFlowMessageFactory;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.plugins.Factory;
import org.apache.logging.log4j.plugins.Named;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.SingletonFactory;
import org.apache.logging.log4j.plugins.condition.ConditionalOnMissingBinding;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.spi.CopyOnWrite;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.jspecify.annotations.Nullable;

public final class CoreDefaultBundle {
    @SingletonFactory
    @ConditionalOnMissingBinding
    public Provider provider(ConfigurableInstanceFactory instanceFactory) {
        return new Log4jProvider(instanceFactory);
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public LoggerContextFactory loggerContextFactory(ConfigurableInstanceFactory instanceFactory) {
        return new Log4jContextFactory(instanceFactory);
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public MessageFactory defaultMessageFactory(RecyclerFactory recyclerFactory) {
        return new ReusableMessageFactory(recyclerFactory);
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public FlowMessageFactory defaultFlowMessageFactory() {
        return new DefaultFlowMessageFactory();
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public RecyclerFactory defaultRecyclerFactory(PropertyEnvironment environment, ClassLoader loader, @Named(value={"StatusLogger"}) @Named(value={"StatusLogger"}) Logger statusLogger) {
        @Nullable String providerName = ((RecyclerProperties)environment.getProperty(RecyclerProperties.class)).factory();
        List<RecyclerFactoryProvider> providers = ServiceLoaderUtil.safeStream(RecyclerFactoryProvider.class, ServiceLoader.load(RecyclerFactoryProvider.class, loader), (Logger)statusLogger).sorted(Comparator.comparing(RecyclerFactoryProvider::getOrder)).toList();
        String providerNames = providers.stream().map(provider -> "`" + provider.getName() + "`").collect(Collectors.joining(", "));
        if (providerName != null) {
            @Nullable RecyclerFactoryProvider matchingProvider = providers.stream().filter(provider -> provider.getName().equals(providerName)).findFirst().orElse(null);
            if (matchingProvider != null) {
                return matchingProvider.createForEnvironment(environment);
            }
            statusLogger.error("Configured recycler factory provider `{}` is not found! Available recycler factory providers: {}. Will choose the first one available for the current environment.", (Object)providerName, (Object)providerNames);
        }
        return providers.stream().map(provider -> provider.createForEnvironment(environment)).findFirst().orElseThrow(() -> new IllegalStateException("None of the available recycler factory providers are found to be available for the current environment: " + providerNames));
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public ContextSelector defaultContextSelector(ConfigurableInstanceFactory instanceFactory) {
        return SystemUtils.isOsAndroid() ? new BasicContextSelector(instanceFactory) : new ClassLoaderContextSelector(instanceFactory);
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public ShutdownCallbackRegistry defaultShutdownCallbackRegistry() {
        return new DefaultShutdownCallbackRegistry();
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public NanoClock defaultNanoClock() {
        return new DummyNanoClock();
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public ContextDataInjector defaultContextDataInjector() {
        ReadOnlyThreadContextMap threadContextMap = ThreadContext.getThreadContextMap();
        if (threadContextMap != null) {
            return threadContextMap instanceof CopyOnWrite ? new ThreadContextDataInjector.ForCopyOnWriteThreadContextMap() : new ThreadContextDataInjector.ForGarbageFreeThreadContextMap();
        }
        return new ThreadContextDataInjector.ForDefaultThreadContextMap();
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public LogEventFactory reusableLogEventFactory(ContextDataInjector injector, Clock clock, NanoClock nanoClock, RecyclerFactory recyclerFactory) {
        return new ReusableLogEventFactory(injector, clock, nanoClock, recyclerFactory);
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public InterpolatorFactory interpolatorFactory(@Namespace(value="Lookup") @Namespace(value="Lookup") Map<String, Supplier<StrLookup>> strLookupPlugins) {
        return defaultLookup -> new Interpolator(defaultLookup, strLookupPlugins);
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public ConfigurationStrSubstitutor configurationStrSubstitutor(InterpolatorFactory factory) {
        return new ConfigurationStrSubstitutor(factory.newInterpolator(null));
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public RuntimeStrSubstitutor runtimeStrSubstitutor(InterpolatorFactory factory) {
        return new RuntimeStrSubstitutor(factory.newInterpolator(null));
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public ConfigurationFactory configurationFactory() {
        return new DefaultConfigurationFactory();
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public URIConfigurationFactory configurationFactory(ConfigurationFactory factory) {
        return factory;
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public MergeStrategy defaultMergeStrategy() {
        return new DefaultMergeStrategy();
    }

    @SingletonFactory
    @Named(value={"StatusLogger"})
    @ConditionalOnMissingBinding
    public @Named(value={"StatusLogger"}) Level defaultStatusLevel(PropertyEnvironment environment) {
        return ((CoreProperties.StatusLoggerProperties)environment.getProperty(CoreProperties.StatusLoggerProperties.class)).level();
    }

    @SingletonFactory
    @Named(value={"StatusLogger"})
    @ConditionalOnMissingBinding
    public @Named(value={"StatusLogger"}) Logger defaultStatusLogger() {
        return StatusLogger.getLogger();
    }

    @Factory
    @ConditionalOnMissingBinding
    public AsyncQueueFullPolicy asyncQueueFullPolicy(PropertyEnvironment environment, @Named(value={"StatusLogger"}) @Named(value={"StatusLogger"}) Logger statusLogger) {
        return AsyncQueueFullPolicyFactory.create((CoreProperties.QueueFullPolicyProperties)environment.getProperty(CoreProperties.QueueFullPolicyProperties.class), statusLogger);
    }
}

