/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jmeter.report.processor.graph;

import org.apache.jmeter.report.core.Sample;

/**
 * The class LatencyValueSelector provides a projection from a sample to its
 * latency.
 *
 * @since 3.0
 */
public class LatencyValueSelector extends AbstractGraphValueSelector {

    /**
     * @param ignoreTransactionController boolean ignore {@link org.apache.jmeter.samplers.SampleResult}
               generated by {@link org.apache.jmeter.control.TransactionController}
     */
    public LatencyValueSelector(boolean ignoreTransactionController) {
        super(ignoreTransactionController);
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * org.apache.jmeter.report.csv.processor.GraphValueSelector#select(java
     * .lang.String, java.lang.Object, org.apache.jmeter.report.csv.core.Sample)
     */
    @Override
    public Double select(String series, Sample sample) {
        if(isIgnoreTransactionController()) {
            if(!sample.isController()) {
                return (double) sample.getLatency();
            }
        } else {
            if(!sample.isEmptyController()) {
                return (double) sample.getLatency();
            }
        }
        return null;
    }

}
