/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.FunTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J \u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0016J\u0017\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0017\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/IdentityTransform;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/FunTransform;", "()V", "apply", "", "", "l", "applyInverse", "createApplicableDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "middle", "(Ljava/lang/Double;)Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "hasDomainLimits", "", "isInDomain", "v", "(Ljava/lang/Double;)Z", "toApplicableDomain", "range", "plot-base"})
public final class IdentityTransform
extends FunTransform {
    public IdentityTransform() {
        super((Function1<? super Double, Double>)((Function1)1.INSTANCE), (Function1<? super Double, Double>)((Function1)2.INSTANCE));
    }

    @Override
    public boolean hasDomainLimits() {
        return false;
    }

    @Override
    public boolean isInDomain(@Nullable Double v) {
        return SeriesUtil.INSTANCE.isFinite(v);
    }

    @Override
    @NotNull
    public DoubleSpan createApplicableDomain(@Nullable Double middle) {
        if (middle == null) {
            return this.createApplicableDomain(0.0);
        }
        double d = middle;
        double middle2 = !Double.isInfinite(d) && !Double.isNaN(d) ? middle : 0.0;
        return new DoubleSpan(middle2 - 0.5, middle2 + 0.5);
    }

    @Override
    @NotNull
    public DoubleSpan toApplicableDomain(@NotNull DoubleSpan range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return range;
    }

    @Override
    @NotNull
    public List<Double> apply(@NotNull List<?> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        return this.safeCastToDoubles(l);
    }

    @Override
    @NotNull
    public List<Double> applyInverse(@NotNull List<Double> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        return l;
    }
}

