/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkGAMA;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "gamma", "", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "Companion", "plot-api"})
public final class PngChunkGAMA
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double gamma;
    @NotNull
    public static final String ID = "gAMA";

    public PngChunkGAMA(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = this.createEmptyChunk(4, true);
        int g = (int)(this.gamma * (double)100000 + 0.5);
        PngHelperInternal.INSTANCE.writeInt4tobytes(g, c.getData(), 0);
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk.getLen() != 4) {
            throw new PngjException("bad chunk " + chunk);
        }
        int g = PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 0);
        this.gamma = (double)g / 100000.0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkGAMA$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

