/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import javax.swing.JPanel;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.protocol.http.config.gui.GraphQLUrlConfigGui;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBaseSchema;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="graphql_http_sampler_title")
public class GraphQLHTTPSamplerGui
extends HttpTestSampleGui {
    private static final long serialVersionUID = 1L;

    @Override
    public void assignDefaultValues(TestElement element) {
        super.assignDefaultValues(element);
        HTTPSamplerBaseSchema.INSTANCE schema = HTTPSamplerBaseSchema.INSTANCE;
        element.set(schema.getMethod(), "POST");
        element.set(schema.getPostBodyRaw(), Boolean.valueOf(true));
        GraphQLHTTPSamplerGui.disableMultipart(element);
    }

    @Override
    public void modifyTestElement(TestElement sampler) {
        super.modifyTestElement(sampler);
        GraphQLHTTPSamplerGui.disableMultipart(sampler);
    }

    private static void disableMultipart(TestElement sampler) {
        HTTPSamplerBaseSchema.INSTANCE schema = HTTPSamplerBaseSchema.INSTANCE;
        sampler.set(schema.getUseBrowserCompatibleMultipart(), Boolean.valueOf(false));
        sampler.set(schema.getUseMultipartPost(), Boolean.valueOf(false));
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"graphql_http_sampler_title");
    }

    public String getDocAnchor() {
        return super.getStaticLabel().replace(' ', '_');
    }

    @Override
    protected JPanel createEmbeddedRsrcPanel() {
        JPanel panel = super.createEmbeddedRsrcPanel();
        panel.setVisible(false);
        return panel;
    }

    @Override
    protected UrlConfigGui createUrlConfigGui() {
        GraphQLUrlConfigGui configGui = new GraphQLUrlConfigGui();
        configGui.setBorder(this.makeBorder());
        return configGui;
    }
}

