/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.customRenderers.axisValue.AxisValueRenderEvent;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.imageMap.RectMapArea;
import org.jCharts.properties.BarChartProperties;
import org.jCharts.properties.DataAxisProperties;

abstract class BarChart {
    BarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        BarChartProperties barChartProperties = (BarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        if (axisChart.getAxisProperties().isPlotHorizontal()) {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getXAxisProperties();
            float f = axisChart.getYAxis().getScalePixelWidth() * barChartProperties.getPercentage();
            float f2 = axisChart.getXAxis().getZeroLineCoordinate();
            float f3 = axisChart.getYAxis().getLastTickY() - f / 2.0f;
            float f4 = 0.0f;
            float f5 = f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, f4, f5);
            BarChart.horizontalPlot(axisChart, iAxisChartDataSet, barChartProperties, dataAxisProperties, graphics2D, float_, f2);
        } else {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
            float f = axisChart.getXAxis().getScalePixelWidth() * barChartProperties.getPercentage();
            float f6 = axisChart.getXAxis().getTickStart() - f / 2.0f;
            float f7 = axisChart.getYAxis().getZeroLineCoordinate();
            float f8 = f;
            float f9 = 0.0f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f6, f7, f8, f9);
            BarChart.verticalPlot(axisChart, iAxisChartDataSet, barChartProperties, dataAxisProperties, graphics2D, float_, f7);
        }
    }

    private static void horizontalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, BarChartProperties barChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f) {
        int n = axisChart.getYAxis().getNumberOfScaleItems() - 1;
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        float_2.y = axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f;
        float_2.height = axisChart.getYAxis().getScalePixelWidth() - 1.0f;
        float_2.x = axisChart.getXAxis().getOrigin() + 1.0f;
        float_2.width = axisChart.getXAxis().getPixelLength() - 1.0f;
        AxisValueRenderEvent axisValueRenderEvent = new AxisValueRenderEvent(axisChart, iAxisChartDataSet, graphics2D, float_2, axisChart.getXAxis().getZeroLineCoordinate());
        axisValueRenderEvent.setDataSetIndex(0);
        int n2 = 0;
        while (n2 < iAxisChartDataSet.getNumberOfDataItems()) {
            graphics2D.setPaint(iAxisChartDataSet.getPaint(0));
            axisValueRenderEvent.setValueX(axisChart.getXAxis().getZeroLineCoordinate());
            axisValueRenderEvent.setValueY((float)float_.getCenterY());
            axisValueRenderEvent.setValueIndex(n2);
            barChartProperties.firePreRender(axisValueRenderEvent);
            if (iAxisChartDataSet.getValue(0, n2) != 0.0) {
                if (iAxisChartDataSet.getValue(0, n2) < 0.0) {
                    float_.x = axisChart.getXAxis().computeAxisCoordinate(axisChart.getXAxis().getOrigin(), iAxisChartDataSet.getValue(0, n2), axisChart.getXAxis().getScaleCalculator().getMinValue());
                    float_.width = f - float_.x;
                    axisValueRenderEvent.setValueX(float_.x);
                } else {
                    float_.x = f;
                    float_.width = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(0, n2), axisChart.getXAxis().getOneUnitPixelSize());
                    axisValueRenderEvent.setValueX(float_.x + float_.width);
                }
                if (float_.width != 0.0f) {
                    graphics2D.fill(float_);
                    if (barChartProperties.getShowOutlinesFlag()) {
                        barChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                    }
                    if (axisChart.getGenerateImageMapFlag()) {
                        String string = axisChart.getYAxis().getAxisLabelsGroup() != null ? axisChart.getYAxis().getAxisLabelsGroup().getTextTag(n).getText() : null;
                        axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(0, n2), string, iAxisChartDataSet.getLegendLabel(0)));
                        --n;
                    }
                }
            }
            barChartProperties.firePostRender(axisValueRenderEvent);
            float_2.y += axisChart.getYAxis().getScalePixelWidth();
            float_.y += axisChart.getYAxis().getScalePixelWidth();
            ++n2;
        }
    }

    private static void verticalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, BarChartProperties barChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f) {
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        float_2.x = axisChart.getXAxis().getOrigin() + 1.0f;
        float_2.y = axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f;
        float_2.width = axisChart.getXAxis().getScalePixelWidth() - 1.0f;
        float_2.height = axisChart.getYAxis().getPixelLength() - 1.0f;
        AxisValueRenderEvent axisValueRenderEvent = new AxisValueRenderEvent(axisChart, iAxisChartDataSet, graphics2D, float_2, axisChart.getYAxis().getZeroLineCoordinate());
        axisValueRenderEvent.setDataSetIndex(0);
        int n = 0;
        while (n < iAxisChartDataSet.getNumberOfDataItems()) {
            graphics2D.setPaint(iAxisChartDataSet.getPaint(0));
            axisValueRenderEvent.setValueX((float)float_.getCenterX());
            axisValueRenderEvent.setValueY(axisChart.getYAxis().getZeroLineCoordinate());
            axisValueRenderEvent.setValueIndex(n);
            barChartProperties.firePreRender(axisValueRenderEvent);
            if (iAxisChartDataSet.getValue(0, n) != 0.0) {
                if (iAxisChartDataSet.getValue(0, n) < 0.0) {
                    float_.y = f;
                    float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(0, n), axisChart.getYAxis().getOneUnitPixelSize());
                    axisValueRenderEvent.setValueY(float_.y + float_.height);
                } else {
                    float_.y = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(0, n), axisChart.getYAxis().getScaleCalculator().getMinValue());
                    float_.height = f - float_.y;
                    axisValueRenderEvent.setValueY(float_.y);
                }
                if (float_.height != 0.0f) {
                    graphics2D.fill(float_);
                    if (barChartProperties.getShowOutlinesFlag()) {
                        barChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                        graphics2D.setPaint(iAxisChartDataSet.getPaint(0));
                    }
                    if (axisChart.getGenerateImageMapFlag()) {
                        String string = axisChart.getXAxis().getAxisLabelsGroup() != null ? axisChart.getXAxis().getAxisLabelsGroup().getTextTag(n).getText() : null;
                        axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(0, n), string, iAxisChartDataSet.getLegendLabel(0)));
                    }
                }
            }
            barChartProperties.firePostRender(axisValueRenderEvent);
            float_2.x += axisChart.getXAxis().getScalePixelWidth();
            float_.x += axisChart.getXAxis().getScalePixelWidth();
            ++n;
        }
    }

    static float computeScaleHeightOfValue(double d, double d2) {
        return (float)Math.abs(d * d2);
    }
}

