/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.text.Format;
import java.util.Date;

public class TableSample
implements Serializable,
Comparable<TableSample> {
    private static final long serialVersionUID = 240L;
    private final long totalSamples;
    private final int sampleCount;
    private final long startTime;
    private final String threadName;
    private final String label;
    private final long elapsed;
    private final boolean success;
    private final long bytes;
    private final long sentBytes;
    private final long latency;
    private final long connect;

    @Deprecated
    public TableSample() {
        this(0L, 1, 0L, "", "", 0L, true, 0L, 0L, 0L, 0L);
    }

    public TableSample(long totalSamples, int sampleCount, long startTime, String threadName, String label, long elapsed, boolean success, long bytes, long sentBytes, long latency, long connect) {
        this.totalSamples = totalSamples;
        this.sampleCount = sampleCount;
        this.startTime = startTime;
        this.threadName = threadName;
        this.label = label;
        this.elapsed = sampleCount > 0 ? elapsed / (long)sampleCount : 0L;
        this.bytes = sampleCount > 0 ? bytes / (long)sampleCount : 0L;
        this.sentBytes = sampleCount > 0 ? sentBytes / (long)sampleCount : 0L;
        this.success = success;
        this.latency = latency;
        this.connect = connect;
    }

    public long getBytes() {
        return this.bytes;
    }

    public String getSampleNumberString() {
        StringBuilder sb = new StringBuilder();
        if (this.sampleCount > 1) {
            sb.append(this.totalSamples - (long)this.sampleCount + 1L);
            sb.append('-');
        }
        sb.append(this.totalSamples);
        return sb.toString();
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getStartTimeFormatted(Format format) {
        return format.format(new Date(this.getStartTime()));
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public int compareTo(TableSample o) {
        TableSample oo = o;
        return this.totalSamples - oo.totalSamples < 0L ? -1 : (this.totalSamples == oo.totalSamples ? 0 : 1);
    }

    public boolean equals(Object o) {
        return o instanceof TableSample && this.compareTo((TableSample)o) == 0;
    }

    public int hashCode() {
        return (int)(this.totalSamples ^ this.totalSamples >>> 32);
    }

    public long getLatency() {
        return this.latency;
    }

    public long getConnectTime() {
        return this.connect;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }
}

