/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import jodd.io.StreamUtil;
import jodd.util.StringUtil;

public class PathUtil {
    public static Path resolve(Path base, String child) {
        if (StringUtil.startsWithChar(child, File.separatorChar)) {
            child = child.substring(1);
        }
        return base.resolve(child);
    }

    public static Path resolve(Path path, String ... childs) {
        for (String child : childs) {
            path = PathUtil.resolve(path, child);
        }
        return path;
    }

    public static String readString(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            StringWriter writer = new StringWriter();
            StreamUtil.copy((Reader)reader, writer);
            String string = writer.toString();
            return string;
        }
    }

    public static void deleteFileTree(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

