/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadLocalSecureRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SaltedMessageDigestInMemoryPasswordEncoder
extends InMemoryPasswordEncoder {
    private final boolean saltAfterClearPassword;
    private final boolean saltAfterMessageDigest;
    private final int digestLengthBytes;
    private final int numSaltBytes;
    @NotNull
    private final MessageDigest messageDigest;

    public SaltedMessageDigestInMemoryPasswordEncoder(@NotNull String prefix, @Nullable PasswordEncoderOutputFormatter outputFormatter, @NotNull MessageDigest messageDigest, int numSaltBytes, boolean saltAfterClearPassword, boolean saltAfterMessageDigest) {
        super(prefix, outputFormatter);
        Validator.ensureNotNull(messageDigest);
        this.messageDigest = messageDigest;
        this.digestLengthBytes = messageDigest.getDigestLength();
        Validator.ensureTrue(this.digestLengthBytes > 0, "The message digest use a fixed digest length, and that length must be greater than zero.");
        this.numSaltBytes = numSaltBytes;
        Validator.ensureTrue(numSaltBytes > 0, "numSaltBytes must be greater than zero.");
        this.saltAfterClearPassword = saltAfterClearPassword;
        this.saltAfterMessageDigest = saltAfterMessageDigest;
    }

    @NotNull
    public String getDigestAlgorithm() {
        return this.messageDigest.getAlgorithm();
    }

    public int getDigestLengthBytes() {
        return this.digestLengthBytes;
    }

    public int getNumSaltBytes() {
        return this.numSaltBytes;
    }

    public boolean isSaltAfterClearPassword() {
        return this.saltAfterClearPassword;
    }

    public boolean isSaltAfterMessageDigest() {
        return this.saltAfterMessageDigest;
    }

    @Override
    @NotNull
    protected byte[] encodePassword(@NotNull byte[] clearPassword, @NotNull ReadOnlyEntry userEntry, @NotNull List<Modification> modifications) throws LDAPException {
        byte[] salt = new byte[this.numSaltBytes];
        ThreadLocalSecureRandom.get().nextBytes(salt);
        byte[] saltedPassword = this.saltAfterClearPassword ? SaltedMessageDigestInMemoryPasswordEncoder.concatenate(clearPassword, salt) : SaltedMessageDigestInMemoryPasswordEncoder.concatenate(salt, clearPassword);
        byte[] digest = this.messageDigest.digest(saltedPassword);
        if (this.saltAfterMessageDigest) {
            return SaltedMessageDigestInMemoryPasswordEncoder.concatenate(digest, salt);
        }
        return SaltedMessageDigestInMemoryPasswordEncoder.concatenate(salt, digest);
    }

    @NotNull
    private static byte[] concatenate(@NotNull byte[] b1, @NotNull byte[] b2) {
        byte[] combined = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, combined, 0, b1.length);
        System.arraycopy(b2, 0, combined, b1.length, b2.length);
        return combined;
    }

    @Override
    protected void ensurePreEncodedPasswordAppearsValid(@NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry, @NotNull List<Modification> modifications) throws LDAPException {
        if (unPrefixedUnFormattedEncodedPasswordBytes.length <= this.digestLengthBytes) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_SALTED_DIGEST_PW_ENCODER_PRE_ENCODED_LENGTH_MISMATCH.get(this.messageDigest.getAlgorithm(), unPrefixedUnFormattedEncodedPasswordBytes.length, this.digestLengthBytes + 1));
        }
    }

    @Override
    protected boolean passwordMatches(@NotNull byte[] clearPasswordBytes, @NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry) throws LDAPException {
        int numComputedSaltBytes = unPrefixedUnFormattedEncodedPasswordBytes.length - this.digestLengthBytes;
        if (numComputedSaltBytes <= 0) {
            return false;
        }
        byte[] salt = new byte[numComputedSaltBytes];
        byte[] digest = new byte[this.digestLengthBytes];
        if (this.saltAfterMessageDigest) {
            System.arraycopy(unPrefixedUnFormattedEncodedPasswordBytes, 0, digest, 0, this.digestLengthBytes);
            System.arraycopy(unPrefixedUnFormattedEncodedPasswordBytes, this.digestLengthBytes, salt, 0, salt.length);
        } else {
            System.arraycopy(unPrefixedUnFormattedEncodedPasswordBytes, 0, salt, 0, salt.length);
            System.arraycopy(unPrefixedUnFormattedEncodedPasswordBytes, salt.length, digest, 0, this.digestLengthBytes);
        }
        byte[] saltedPassword = this.saltAfterClearPassword ? SaltedMessageDigestInMemoryPasswordEncoder.concatenate(clearPasswordBytes, salt) : SaltedMessageDigestInMemoryPasswordEncoder.concatenate(salt, clearPasswordBytes);
        byte[] computedDigest = this.messageDigest.digest(saltedPassword);
        return Arrays.equals(computedDigest, digest);
    }

    @Override
    @NotNull
    protected byte[] extractClearPassword(@NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry) throws LDAPException {
        throw new LDAPException(ResultCode.NOT_SUPPORTED, ListenerMessages.ERR_SALTED_DIGEST_PW_ENCODER_NOT_REVERSIBLE.get());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SaltedMessageDigestInMemoryPasswordEncoder(prefix='");
        buffer.append(this.getPrefix());
        buffer.append("', outputFormatter=");
        PasswordEncoderOutputFormatter outputFormatter = this.getOutputFormatter();
        if (outputFormatter == null) {
            buffer.append("null");
        } else {
            outputFormatter.toString(buffer);
        }
        buffer.append(", digestAlgorithm='");
        buffer.append(this.messageDigest.getAlgorithm());
        buffer.append("', digestLengthBytes=");
        buffer.append(this.messageDigest.getDigestLength());
        buffer.append(", numSaltBytes=");
        buffer.append(this.numSaltBytes);
        buffer.append(", saltAfterClearPassword=");
        buffer.append(this.saltAfterClearPassword);
        buffer.append(", saltAfterMessageDigest=");
        buffer.append(this.saltAfterMessageDigest);
        buffer.append(')');
    }
}

