/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import it.unimi.dsi.fastutil.longs.LongList;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;

public class PartialRange {
    private final long lowVal;
    private final long upVal;

    public PartialRange(long lowVal, long upVal) throws DecodingException {
        this.checkArgument(lowVal != 0L, "'lowVal' cannot be equal to 0");
        this.checkArgument(upVal != 0L, "'upVal' cannot be equal to 0");
        this.checkArgument(lowVal > 0L == upVal > 0L, "Both 'upVal' and 'lowVal' must have the same sign, got lowVal=" + lowVal + " and upVal=" + upVal);
        if (Math.abs(lowVal) <= Math.abs(upVal)) {
            this.lowVal = lowVal;
            this.upVal = upVal;
        } else {
            this.lowVal = upVal;
            this.upVal = lowVal;
        }
    }

    public void checkArgument(boolean condition, String explanation) throws DecodingException {
        if (!condition) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid partial range: " + explanation);
        }
    }

    public long getLowVal() {
        return this.lowVal;
    }

    public long getUpVal() {
        return this.upVal;
    }

    public LongList filter(LongList uids) {
        if (this.lowVal > 0L) {
            int from = this.stanitize((int)this.lowVal - 1, uids);
            int to = this.stanitize((int)this.upVal, uids);
            return uids.subList(from, to);
        }
        int from = this.stanitize(uids.size() + (int)this.upVal, uids);
        int to = this.stanitize(uids.size() + (int)this.lowVal + 1, uids);
        return uids.subList(from, to);
    }

    public int stanitize(int i, LongList longs) {
        if (i < 0) {
            return 0;
        }
        if (i > longs.size()) {
            return longs.size();
        }
        return i;
    }
}

