/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.api;

import com.github.fge.lambdas.Throwing;
import java.util.Iterator;
import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface UsersRepository {
    public static final String LOCALPART_DETAIL_DELIMITER = "+";

    public void addUser(Username var1, String var2) throws UsersRepositoryException;

    public User getUserByName(Username var1) throws UsersRepositoryException;

    public void updateUser(User var1) throws UsersRepositoryException;

    public void removeUser(Username var1) throws UsersRepositoryException;

    public boolean contains(Username var1) throws UsersRepositoryException;

    public Publisher<Boolean> containsReactive(Username var1);

    public Optional<Username> test(Username var1, String var2) throws UsersRepositoryException;

    public int countUsers() throws UsersRepositoryException;

    public Iterator<Username> list() throws UsersRepositoryException;

    public Publisher<Username> listReactive();

    public boolean supportVirtualHosting() throws UsersRepositoryException;

    default public Username getUsername(MailAddress mailAddress) throws UsersRepositoryException {
        if (this.supportVirtualHosting()) {
            return Username.of((String)mailAddress.stripDetails(LOCALPART_DETAIL_DELIMITER).asString());
        }
        return Username.of((String)mailAddress.stripDetails(LOCALPART_DETAIL_DELIMITER).getLocalPart());
    }

    public MailAddress getMailAddressFor(Username var1) throws UsersRepositoryException;

    public boolean isAdministrator(Username var1) throws UsersRepositoryException;

    public boolean isReadOnly();

    default public void assertValid(Username username) throws UsersRepositoryException {
        if (username.getDomainPart().isPresent() != this.supportVirtualHosting()) {
            throw new UsersRepositoryException(username.asString() + " username candidate do not match the virtualHosting strategy");
        }
    }

    default public Mono<Void> assertValidReactive(Username username) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.assertValid(username)).sneakyThrow()).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then();
    }

    default public Publisher<Username> listUsersOfADomainReactive(Domain domain) {
        return Flux.from(this.listReactive()).filter(username -> username.getDomainPart().map(arg_0 -> ((Domain)domain).equals(arg_0)).orElse(false));
    }
}

