/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.input.UnsynchronizedBufferedInputStream;
import org.apache.commons.io.input.UnsynchronizedFilterInputStream;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class RecoverAttachment
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecoverAttachment.class);
    private static final Class<Map<String, AttributeValue<?>>> MAP_STRING_BYTES_CLASS = Map.class;
    private static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    private AttributeName attributeName;

    public void init() throws MailetException {
        String attributeNameRaw = this.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        if (attributeNameRaw == null) {
            throw new MailetException("attribute is a mandatory parameter");
        }
        LOGGER.debug("RecoverAttachment is initialised with attribute [{}]", (Object)attributeNameRaw);
        this.attributeName = AttributeName.of((String)attributeNameRaw);
    }

    public void service(Mail mail) throws MailetException {
        AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)this.attributeName, MAP_STRING_BYTES_CLASS).ifPresent(Throwing.consumer(attachments -> this.processAttachment(mail, (Map<String, AttributeValue<?>>)attachments)).sneakyThrow());
    }

    private void processAttachment(Mail mail, Map<String, AttributeValue<?>> attachments) throws MailetException {
        MimeMessage message;
        try {
            message = mail.getMessage();
        }
        catch (MessagingException e) {
            throw new MailetException("Could not retrieve message from Mail object", (Exception)((Object)e));
        }
        Iterator<AttributeValue<?>> i = attachments.values().iterator();
        try {
            while (i.hasNext()) {
                if (!(i.next().getValue() instanceof byte[])) continue;
                byte[] bytes = (byte[])i.next().getValue();
                UnsynchronizedFilterInputStream is = ((UnsynchronizedFilterInputStream.Builder)UnsynchronizedBufferedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(bytes))).get();
                MimeBodyPart p = new MimeBodyPart((InputStream)is);
                if (!message.isMimeType("multipart/*") || !(message.getContent() instanceof MimeMultipart)) {
                    Object content = message.getContent();
                    String contentType = message.getContentType();
                    MimeMultipart mimeMultipart = new MimeMultipart();
                    message.setContent((Multipart)mimeMultipart);
                    message.saveChanges();
                    mimeMultipart.setParent((Part)message);
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    mimeMultipart.addBodyPart((BodyPart)bodyPart);
                    bodyPart.setContent(content, contentType);
                }
                ((MimeMultipart)message.getContent()).addBodyPart((BodyPart)p);
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            LOGGER.error("MessagingException in recoverAttachment", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("IOException in recoverAttachment", (Throwable)e);
        }
    }

    public String getMailetInfo() {
        return "RecoverAttachment Mailet";
    }
}

