/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.change;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.time.Clock;
import java.time.ZonedDateTime;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.JmapChange;
import org.apache.james.jmap.api.change.MailboxAndEmailChange;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.model.State;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.AccountIdRegistrationKey;
import org.apache.james.jmap.change.EmailDeliveryTypeName$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxChangeListener$;
import org.apache.james.jmap.change.MailboxChangeListenerGroup;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.change.StateChangeEvent;
import org.apache.james.jmap.core.UuidState;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.MapablePublisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r=u!B\u001b7\u0011\u0003\te!B\"7\u0011\u0003!\u0005\"B*\u0002\t\u0003!\u0006bB+\u0002\u0005\u0004%\tA\u0016\u0005\u0007;\u0006\u0001\u000b\u0011B,\t\u000fy\u000b\u0011\u0011!CA?\"I1qO\u0001\u0002\u0002\u0013\u00055\u0011\u0010\u0005\n\u0007\u0017\u000b\u0011\u0011!C\u0005\u0007\u001b3Aa\u0011\u001cAC\"Q\u0011q\u0002\u0005\u0003\u0016\u0004%\t!!\u0005\t\u0015\u0005m\u0001B!E!\u0002\u0013\t\u0019\u0002\u0003\u0006\u0002\u001e!\u0011)\u001a!C\u0001\u0003?A!\"a\f\t\u0005#\u0005\u000b\u0011BA\u0011\u0011)\t\t\u0004\u0003BK\u0002\u0013\u0005\u00111\u0007\u0005\u000b\u0003\u0007B!\u0011#Q\u0001\n\u0005U\u0002BCA#\u0011\tU\r\u0011\"\u0001\u0002H!Q\u0011q\n\u0005\u0003\u0012\u0003\u0006I!!\u0013\t\u0015\u0005E\u0003B!f\u0001\n\u0003\t\u0019\u0006\u0003\u0006\u0002b!\u0011\t\u0012)A\u0005\u0003+B!\"a\u0019\t\u0005+\u0007I\u0011AA3\u0011)\t\u0019\b\u0003B\tB\u0003%\u0011q\r\u0005\u000b\u0003kB!Q3A\u0005\u0002\u0005]\u0004BCAC\u0011\tE\t\u0015!\u0003\u0002z!11\u000b\u0003C\u0001\u0003\u000fCq!a.\t\t\u0003\nI\fC\u0004\u00028\"!\t%a6\t\u000f\u0005\u001d\b\u0002\"\u0003\u0002j\"9\u0011\u0011 \u0005\u0005B\u0005m\bb\u0002B\u0002\u0011\u0011\u0005#Q\u0001\u0005\b\u0005\u001fAA\u0011\u0002B\t\u0011\u001d\u0011Y\u0005\u0003C\u0005\u0005\u001bBqA!\u0016\t\t\u0013\u00119\u0006C\u0004\u0003\\!!IA!\u0018\t\u000f\tE\u0005\u0002\"\u0003\u0003\u0014\"9!q\u0013\u0005\u0005\n\te\u0005b\u0002Ba\u0011\u0011%!1\u0019\u0005\n\u0005\u001fD\u0011\u0011!C\u0001\u0005#D\u0011B!9\t#\u0003%\tAa9\t\u0013\te\b\"%A\u0005\u0002\tm\b\"\u0003B\u0000\u0011E\u0005I\u0011AB\u0001\u0011%\u0019)\u0001CI\u0001\n\u0003\u00199\u0001C\u0005\u0004\f!\t\n\u0011\"\u0001\u0004\u000e!I1\u0011\u0003\u0005\u0012\u0002\u0013\u000511\u0003\u0005\n\u0007/A\u0011\u0013!C\u0001\u00073A\u0011b!\b\t\u0003\u0003%\tea\b\t\u0013\r\u001d\u0002\"!A\u0005\u0002\r%\u0002\"CB\u0019\u0011\u0005\u0005I\u0011AB\u001a\u0011%\u0019y\u0004CA\u0001\n\u0003\u001a\t\u0005C\u0005\u0004P!\t\t\u0011\"\u0001\u0004R!I1Q\u000b\u0005\u0002\u0002\u0013\u00053q\u000b\u0005\n\u00077B\u0011\u0011!C!\u0007;B\u0011ba\u0018\t\u0003\u0003%\te!\u0019\t\u0013\r\r\u0004\"!A\u0005B\r\u0015\u0014!F'bS2\u0014w\u000e_\"iC:<W\rT5ti\u0016tWM\u001d\u0006\u0003oa\naa\u00195b]\u001e,'BA\u001d;\u0003\u0011QW.\u00199\u000b\u0005mb\u0014!\u00026b[\u0016\u001c(BA\u001f?\u0003\u0019\t\u0007/Y2iK*\tq(A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002C\u00035\taGA\u000bNC&d'm\u001c=DQ\u0006tw-\u001a'jgR,g.\u001a:\u0014\u0007\u0005)5\n\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000b!![8\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u000ba\u0001T(H\u000f\u0016\u0013V#A,\u0011\u0005a[V\"A-\u000b\u0005is\u0014!B:mMRR\u0017B\u0001/Z\u0005\u0019aunZ4fe\u00069AjT$H\u000bJ\u0003\u0013!B1qa2LHc\u00041\u0004j\r-4QNB8\u0007c\u001a\u0019h!\u001e\u0011\u0005\tC1#\u0002\u0005cQr|\bCA2g\u001b\u0005!'BA3P\u0003\u0011a\u0017M\\4\n\u0005\u001d$'AB(cU\u0016\u001cG\u000f\u0005\u0002js:\u0011!N\u001e\b\u0003WRt!\u0001\\:\u000f\u00055\u0014hB\u00018r\u001b\u0005y'B\u00019A\u0003\u0019a$o\\8u}%\tq(\u0003\u0002>}%\u00111\bP\u0005\u0003kj\na!\u001a<f]R\u001c\u0018BA<y\u00035)e/\u001a8u\u0019&\u001cH/\u001a8fe*\u0011QOO\u0005\u0003un\u0014!DU3bGRLg/Z$s_V\u0004XI^3oi2K7\u000f^3oKJT!a\u001e=\u0011\u0005\u0019k\u0018B\u0001@H\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u0001\u0002\f9!\u00111AA\u0004\u001d\rq\u0017QA\u0005\u0002\u0011&\u0019\u0011\u0011B$\u0002\u000fA\f7m[1hK&\u0019!+!\u0004\u000b\u0007\u0005%q)\u0001\u0005fm\u0016tGOQ;t+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005]Q\"\u0001=\n\u0007\u0005e\u0001P\u0001\u0005Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%A\fnC&d'm\u001c=DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ssV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tY#\u0004\u0002\u0002&)\u0019q'a\n\u000b\u0007\u0005%\u0002(A\u0002ba&LA!!\f\u0002&\t9R*Y5mE>D8\t[1oO\u0016\u0014V\r]8tSR|'/_\u0001\u0019[\u0006LGNY8y\u0007\"\fgnZ3SKB|7/\u001b;pef\u0004\u0013\u0001F7bS2\u0014w\u000e_\"iC:<WMR1di>\u0014\u00180\u0006\u0002\u00026A!\u0011qGA\u001f\u001d\u0011\t\u0019#!\u000f\n\t\u0005m\u0012QE\u0001\u000e\u001b\u0006LGNY8y\u0007\"\fgnZ3\n\t\u0005}\u0012\u0011\t\u0002\b\r\u0006\u001cGo\u001c:z\u0015\u0011\tY$!\n\u0002+5\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4f\r\u0006\u001cGo\u001c:zA\u0005)R-\\1jY\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JLXCAA%!\u0011\t\u0019#a\u0013\n\t\u00055\u0013Q\u0005\u0002\u0016\u000b6\f\u0017\u000e\\\"iC:<WMU3q_NLGo\u001c:z\u0003Y)W.Y5m\u0007\"\fgnZ3SKB|7/\u001b;pef\u0004\u0013AE3nC&d7\t[1oO\u00164\u0015m\u0019;pef,\"!!\u0016\u0011\t\u0005]\u0013Q\f\b\u0005\u0003G\tI&\u0003\u0003\u0002\\\u0005\u0015\u0012!F'bS2\u0014w\u000e_!oI\u0016k\u0017-\u001b7DQ\u0006tw-Z\u0005\u0005\u0003\u007f\tyF\u0003\u0003\u0002\\\u0005\u0015\u0012aE3nC&d7\t[1oO\u00164\u0015m\u0019;pef\u0004\u0013AD7bS2\u0014w\u000e_'b]\u0006<WM]\u000b\u0003\u0003O\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[R\u0014aB7bS2\u0014w\u000e_\u0005\u0005\u0003c\nYG\u0001\bNC&d'm\u001c=NC:\fw-\u001a:\u0002\u001f5\f\u0017\u000e\u001c2pq6\u000bg.Y4fe\u0002\nQa\u00197pG.,\"!!\u001f\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a P\u0003\u0011!\u0018.\\3\n\t\u0005\r\u0015Q\u0010\u0002\u0006\u00072|7m[\u0001\u0007G2|7m\u001b\u0011\u0015\u001f\u0001\fI)a)\u0002&\u0006\u001d\u0016\u0011VAV\u0003[Cq!a\u0004\u0018\u0001\u0004\t\u0019\u0002\u000b\u0005\u0002\n\u00065\u0015QTAP!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000ba!\u001b8kK\u000e$(BAAL\u0003\u001dQ\u0017m[1si\u0006LA!a'\u0002\u0012\n)a*Y7fI\u0006)a/\u00197vK\u0006\u0012\u0011\u0011U\u0001\u0005\u00156\u000b\u0005\u000bC\u0004\u0002\u001e]\u0001\r!!\t\t\u000f\u0005Er\u00031\u0001\u00026!9\u0011QI\fA\u0002\u0005%\u0003bBA)/\u0001\u0007\u0011Q\u000b\u0005\b\u0003G:\u0002\u0019AA4\u0011\u001d\t)h\u0006a\u0001\u0003sB3aFAY!\u0011\ty)a-\n\t\u0005U\u0016\u0011\u0013\u0002\u0007\u0013:TWm\u0019;\u0002\u001bI,\u0017m\u0019;jm\u0016,e/\u001a8u)\u0011\tY,!4\u0011\r\u0005u\u00161YAd\u001b\t\tyLC\u0002\u0002Bz\nqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0005\u0003\u000b\fyLA\u0005Qk\nd\u0017n\u001d5feB\u00191-!3\n\u0007\u0005-GM\u0001\u0003W_&$\u0007bBAh1\u0001\u0007\u0011\u0011[\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003+\t\u0019.C\u0002\u0002Vb\u0014Q!\u0012<f]R$B!a/\u0002Z\"1Q/\u0007a\u0001\u00037\u0004b!!8\u0002d\u0006EWBAAp\u0015\r\t\toT\u0001\u0005kRLG.\u0003\u0003\u0002f\u0006}'\u0001\u0002'jgR\fa#\\3sO\u0016\u001cF/\u0019;f\u0007\"\fgnZ3Fm\u0016tGo\u001d\u000b\u0007\u0003W\f\t0!>\u0011\u0007\t\u000bi/C\u0002\u0002pZ\u0012\u0001c\u0015;bi\u0016\u001c\u0005.\u00198hK\u00163XM\u001c;\t\u000f\u0005M(\u00041\u0001\u0002l\u0006\u0019qN\\3\t\u000f\u0005](\u00041\u0001\u0002l\u0006)q\u000e\u001e5fe\u0006yq-\u001a;EK\u001a\fW\u000f\u001c;He>,\b\u000f\u0006\u0002\u0002~B!\u0011QCA\u0000\u0013\r\u0011\t\u0001\u001f\u0002\u0006\u000fJ|W\u000f]\u0001\u000bSND\u0015M\u001c3mS:<G\u0003\u0002B\u0004\u0005\u001b\u00012A\u0012B\u0005\u0013\r\u0011Ya\u0012\u0002\b\u0005>|G.Z1o\u0011\u001d\ty\r\ba\u0001\u0003#\f1B[7ba\u000eC\u0017M\\4fgR!!1\u0003B\u0018!\u0019\u0011)B!\n\u0003*5\u0011!q\u0003\u0006\u0005\u00053\u0011Y\"A\u0005qk\nd\u0017n\u001d5fe*\u0019\u0001J!\b\u000b\t\t}!\u0011E\u0001\u0005G>\u0014XM\u0003\u0002\u0003$\u00059!/Z1di>\u0014\u0018\u0002\u0002B\u0014\u0005/\u0011Qa\u0015$mkb\u0004B!a\t\u0003,%!!QFA\u0013\u0005)QU.\u00199DQ\u0006tw-\u001a\u0005\b\u0005ci\u0002\u0019\u0001B\u001a\u00031i\u0017-\u001b7c_b,e/\u001a8u!\u0011\u0011)D!\u0012\u000f\t\t]\"q\b\b\u0005\u0005s\u0011iDD\u0002l\u0005wI1!!\u001c;\u0013\r)\u00181N\u0005\u0005\u0005\u0003\u0012\u0019%A\u0007NC&d'm\u001c=Fm\u0016tGo\u001d\u0006\u0004k\u0006-\u0014\u0002\u0002B$\u0005\u0013\u0012A\"T1jY\n|\u00070\u0012<f]RTAA!\u0011\u0003D\u0005y1/\u0019<f\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\u0003\u0003P\tE\u0003CBA_\u0003\u0007\u0014I\u0003C\u0004\u0003Ty\u0001\rA!\u000b\u0002\u0015)l\u0017\r]\"iC:<W-\u0001\neSN\u0004\u0018m\u0019;DQ\u0006tw-Z#wK:$H\u0003BA^\u00053BqAa\u0015 \u0001\u0004\tY/\u0001\u0006hKR\u001c\u0006.\u0019:fKN$bAa\u0018\u0003v\t\r\u0005C\u0002B\u000b\u0005C\u0012)'\u0003\u0003\u0003d\t]!!B*N_:|\u0007CBA\u0001\u0005O\u0012I'\u0003\u0003\u0002f\u00065\u0001\u0003\u0002B6\u0005cj!A!\u001c\u000b\t\t=\u0014qE\u0001\u0006[>$W\r\\\u0005\u0005\u0005g\u0012iGA\u0005BG\u000e|WO\u001c;JI\"9!q\u000f\u0011A\u0002\te\u0014!C7bS2\u0014w\u000e_%e!\u0011\u0011YHa \u000e\u0005\tu$\u0002\u0002B8\u0003WJAA!!\u0003~\tIQ*Y5mE>D\u0018\n\u001a\u0005\b\u0005\u000b\u0003\u0003\u0019\u0001BD\u0003!)8/\u001a:oC6,\u0007\u0003\u0002BE\u0005\u001bk!Aa#\u000b\u0007\t}!(\u0003\u0003\u0003\u0010\n-%\u0001C+tKJt\u0017-\\3\u0002%Q|7\u000b^1uK\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\u0005\u0003W\u0014)\nC\u0004\u0003T\u0005\u0002\rA!\u000b\u0002\u001f5\f\u0017\u000e\u001c2pqN#\u0018\r^3NCB$BAa'\u00038BA!Q\u0014BS\u0005W\u0013\tL\u0004\u0003\u0003 \n\u0005\u0006C\u00018H\u0013\r\u0011\u0019kR\u0001\u0007!J,G-\u001a4\n\t\t\u001d&\u0011\u0016\u0002\u0004\u001b\u0006\u0004(b\u0001BR\u000fB!!1\u000eBW\u0013\u0011\u0011yK!\u001c\u0003\u0011QK\b/\u001a(b[\u0016\u0004BAa\u001b\u00034&!!Q\u0017B7\u0005\u0015\u0019F/\u0019;f\u0011\u001d\u0011IL\ta\u0001\u0005w\u000bQ\"\\1jY\n|\u0007p\u00115b]\u001e,\u0007\u0003BA\u0012\u0005{KAAa0\u0002&\tiQ*Y5mE>D8\t[1oO\u0016\fQ\"Z7bS2\u001cF/\u0019;f\u001b\u0006\u0004H\u0003\u0002BN\u0005\u000bDqAa2$\u0001\u0004\u0011I-A\u0006f[\u0006LGn\u00115b]\u001e,\u0007\u0003BA\u0012\u0005\u0017LAA!4\u0002&\tYQ)\\1jY\u000eC\u0017M\\4f\u0003\u0011\u0019w\u000e]=\u0015\u001f\u0001\u0014\u0019N!6\u0003X\ne'1\u001cBo\u0005?D\u0011\"a\u0004%!\u0003\u0005\r!a\u0005\t\u0013\u0005uA\u0005%AA\u0002\u0005\u0005\u0002\"CA\u0019IA\u0005\t\u0019AA\u001b\u0011%\t)\u0005\nI\u0001\u0002\u0004\tI\u0005C\u0005\u0002R\u0011\u0002\n\u00111\u0001\u0002V!I\u00111\r\u0013\u0011\u0002\u0003\u0007\u0011q\r\u0005\n\u0003k\"\u0003\u0013!a\u0001\u0003s\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003f*\"\u00111\u0003BtW\t\u0011I\u000f\u0005\u0003\u0003l\nUXB\u0001Bw\u0015\u0011\u0011yO!=\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bz\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t](Q\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005{TC!!\t\u0003h\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAB\u0002U\u0011\t)Da:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u00111\u0011\u0002\u0016\u0005\u0003\u0013\u00129/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r=!\u0006BA+\u0005O\fabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0004\u0016)\"\u0011q\rBt\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]*\"aa\u0007+\t\u0005e$q]\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r\u0005\u0002cA2\u0004$%\u00191Q\u00053\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0019Y\u0003E\u0002G\u0007[I1aa\fH\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019)da\u000f\u0011\u0007\u0019\u001b9$C\u0002\u0004:\u001d\u00131!\u00118z\u0011%\u0019iDLA\u0001\u0002\u0004\u0019Y#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u0007\u0002ba!\u0012\u0004L\rURBAB$\u0015\r\u0019IeR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB'\u0007\u000f\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!qAB*\u0011%\u0019i\u0004MA\u0001\u0002\u0004\u0019)$\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BB\u0011\u00073B\u0011b!\u00102\u0003\u0003\u0005\raa\u000b\u0002\u0011!\f7\u000f[\"pI\u0016$\"aa\u000b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"a!\t\u0002\r\u0015\fX/\u00197t)\u0011\u00119aa\u001a\t\u0013\ruB'!AA\u0002\rU\u0002bBA\b\u000b\u0001\u0007\u00111\u0003\u0005\b\u0003;)\u0001\u0019AA\u0011\u0011\u001d\t\t$\u0002a\u0001\u0003kAq!!\u0012\u0006\u0001\u0004\tI\u0005C\u0004\u0002R\u0015\u0001\r!!\u0016\t\u000f\u0005\rT\u00011\u0001\u0002h!9\u0011QO\u0003A\u0002\u0005e\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007w\u001a9\tE\u0003G\u0007{\u001a\t)C\u0002\u0004\u0000\u001d\u0013aa\u00149uS>t\u0007#\u0005$\u0004\u0004\u0006M\u0011\u0011EA\u001b\u0003\u0013\n)&a\u001a\u0002z%\u00191QQ$\u0003\rQ+\b\u000f\\38\u0011!\u0019IIBA\u0001\u0002\u0004\u0001\u0017a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\t!\r")
public class MailboxChangeListener
implements EventListener.ReactiveGroupEventListener,
Product,
Serializable {
    private final EventBus eventBus;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final MailboxChange.Factory mailboxChangeFactory;
    private final EmailChangeRepository emailChangeRepository;
    private final MailboxAndEmailChange.Factory emailChangeFactory;
    private final MailboxManager mailboxManager;
    private final Clock clock;

    public static Option<Tuple7<EventBus, MailboxChangeRepository, MailboxChange.Factory, EmailChangeRepository, MailboxAndEmailChange.Factory, MailboxManager, Clock>> unapply(MailboxChangeListener x$0) {
        return MailboxChangeListener$.MODULE$.unapply(x$0);
    }

    public static MailboxChangeListener apply(EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory mailboxChangeFactory, EmailChangeRepository emailChangeRepository, MailboxAndEmailChange.Factory emailChangeFactory, MailboxManager mailboxManager, Clock clock) {
        return MailboxChangeListener$.MODULE$.apply(eventBus, mailboxChangeRepository, mailboxChangeFactory, emailChangeRepository, emailChangeFactory, mailboxManager, clock);
    }

    public static Logger LOGGER() {
        return MailboxChangeListener$.MODULE$.LOGGER();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public void event(Event event) throws Exception {
        super.event(event);
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public MailboxChangeRepository mailboxChangeRepository() {
        return this.mailboxChangeRepository;
    }

    public MailboxChange.Factory mailboxChangeFactory() {
        return this.mailboxChangeFactory;
    }

    public EmailChangeRepository emailChangeRepository() {
        return this.emailChangeRepository;
    }

    public MailboxAndEmailChange.Factory emailChangeFactory() {
        return this.emailChangeFactory;
    }

    public MailboxManager mailboxManager() {
        return this.mailboxManager;
    }

    public Clock clock() {
        return this.clock;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        SFlux<JmapChange> qual$1 = this.jmapChanges((MailboxEvents.MailboxEvent)event);
        Function1 & Serializable x$1 = (Function1 & Serializable)jmapChange -> this.saveChangeEvent((JmapChange)jmapChange);
        int x$2 = 16;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SFlux qual$2 = qual$1.flatMap((Function1)x$1, 16, x$3, x$4).map((Function1 & Serializable)jmapChange -> this.toStateChangeEvent((JmapChange)jmapChange));
        Function1 & Serializable x$5 = (Function1 & Serializable)jmapChange -> this.dispactChangeEvent((StateChangeEvent)jmapChange);
        int x$6 = 16;
        int x$7 = qual$2.flatMap$default$3();
        boolean x$8 = qual$2.flatMap$default$4();
        return reactor.core.scala.publisher.package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)qual$2.flatMap((Function1)x$5, 16, x$7, x$8).then());
    }

    public Publisher<Void> reactiveEvent(java.util.List<Event> events) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(events).asScala()).filter((Function1 & Serializable)event -> BoxesRunTime.boxToBoolean((boolean)this.isHandling(event)));
        Function1 & Serializable x$12 = (Function1 & Serializable)event -> this.jmapChanges((MailboxEvents.MailboxEvent)event);
        int x$2 = qual$1.concatMap$default$2();
        SFlux qual$2 = qual$1.concatMap((Function1)x$12, x$2).concatMap((Function1 & Serializable)jmapChange -> this.saveChangeEvent((JmapChange)jmapChange), 16).groupBy((Function1 & Serializable)x$1 -> x$1.getAccountId());
        Function1 & Serializable x$3 = (Function1 & Serializable)group -> group.map((Function1 & Serializable)a -> this.toStateChangeEvent((JmapChange)a)).fold((Object)new StateChangeEvent(Event.EventId.random(), Username.of((String)((AccountId)group.key()).getIdentifier()), (Map<TypeName, State>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), (Function2 & Serializable)(a, b) -> this.mergeStateChangeEvents((StateChangeEvent)a, (StateChangeEvent)b));
        int x$4 = qual$2.flatMap$default$2();
        int x$5 = qual$2.flatMap$default$3();
        boolean x$6 = qual$2.flatMap$default$4();
        SFlux qual$3 = qual$2.flatMap((Function1)x$3, x$4, x$5, x$6);
        Function1 & Serializable x$7 = (Function1 & Serializable)jmapChange -> this.dispactChangeEvent((StateChangeEvent)jmapChange);
        int x$8 = 16;
        int x$9 = qual$3.flatMap$default$3();
        boolean x$10 = qual$3.flatMap$default$4();
        return reactor.core.scala.publisher.package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)qual$3.flatMap((Function1)x$7, 16, x$9, x$10).then());
    }

    private StateChangeEvent mergeStateChangeEvents(StateChangeEvent one, StateChangeEvent other) {
        return new StateChangeEvent(one.eventId(), one.username(), (Map<TypeName, State>)((Map)one.map().$plus$plus(other.map())));
    }

    public Group getDefaultGroup() {
        return new MailboxChangeListenerGroup();
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.MailboxEvent;
    }

    private SFlux<JmapChange> jmapChanges(MailboxEvents.MailboxEvent mailboxEvent) {
        ZonedDateTime now = ZonedDateTime.now(this.clock());
        MailboxId mailboxId = mailboxEvent.getMailboxId();
        Username username = mailboxEvent.getUsername();
        MailboxEvents.MailboxEvent mailboxEvent2 = mailboxEvent;
        if (mailboxEvent2 instanceof MailboxEvents.MailboxAdded) {
            MailboxEvents.MailboxAdded mailboxAdded = (MailboxEvents.MailboxAdded)mailboxEvent2;
            return SFlux$.MODULE$.just((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JmapChange[]{this.mailboxChangeFactory().fromMailboxAdded(mailboxAdded, now)}));
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxRenamed) {
            MailboxEvents.MailboxRenamed mailboxRenamed = (MailboxEvents.MailboxRenamed)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapIterable((Function1 & Serializable)sharees -> CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxRenamed(mailboxRenamed, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees).asJava())).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxACLUpdated) {
            MailboxEvents.MailboxACLUpdated mailboxACLUpdated = (MailboxEvents.MailboxACLUpdated)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapIterable((Function1 & Serializable)sharees -> CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxACLUpdated(mailboxACLUpdated, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees).asJava())).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxDeletion) {
            MailboxEvents.MailboxDeletion mailboxDeletion = (MailboxEvents.MailboxDeletion)mailboxEvent2;
            return SFlux$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxDeletion(mailboxDeletion, now)).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.Added) {
            MailboxEvents.Added added = (MailboxEvents.Added)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapIterable((Function1 & Serializable)sharees -> CollectionConverters$.MODULE$.ListHasAsScala(this.emailChangeFactory().fromAdded(added, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees).asJava())).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.FlagsUpdated) {
            MailboxEvents.FlagsUpdated flagsUpdated = (MailboxEvents.FlagsUpdated)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapIterable((Function1 & Serializable)sharees -> CollectionConverters$.MODULE$.ListHasAsScala(this.emailChangeFactory().fromFlagsUpdated(flagsUpdated, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees).asJava())).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expunged = (MailboxEvents.Expunged)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapMany((Function1 & Serializable)sharees -> SFlux$.MODULE$.apply((Publisher)this.emailChangeFactory().fromExpunged(expunged, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees.map((Function1 & Serializable)x$2 -> x$2.getIdentifier()).map((Function1 & Serializable)username -> Username.of((String)username))).asJava())));
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxSubscribedEvent) {
            MailboxEvents.MailboxSubscribedEvent mailboxSubscribedEvent = (MailboxEvents.MailboxSubscribedEvent)mailboxEvent2;
            return SFlux$.MODULE$.just((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JmapChange[]{this.mailboxChangeFactory().fromMailboxSubscribed(mailboxSubscribedEvent, now)}));
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxUnsubscribedEvent) {
            MailboxEvents.MailboxUnsubscribedEvent mailboxUnsubscribedEvent = (MailboxEvents.MailboxUnsubscribedEvent)mailboxEvent2;
            return SFlux$.MODULE$.just((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JmapChange[]{this.mailboxChangeFactory().fromMailboxUnSubscribed(mailboxUnsubscribedEvent, now)}));
        }
        throw new MatchError((Object)mailboxEvent2);
    }

    private Publisher<JmapChange> saveChangeEvent(JmapChange jmapChange) {
        Mono mono;
        JmapChange jmapChange2 = jmapChange;
        if (jmapChange2 instanceof MailboxChange) {
            MailboxChange mailboxChange = (MailboxChange)jmapChange2;
            mono = this.mailboxChangeRepository().save(mailboxChange).then(Mono.just((Object)jmapChange));
        } else if (jmapChange2 instanceof EmailChange) {
            EmailChange emailChange = (EmailChange)jmapChange2;
            mono = this.emailChangeRepository().save(emailChange).then(Mono.just((Object)jmapChange));
        } else if (jmapChange2 instanceof MailboxAndEmailChange) {
            MailboxAndEmailChange mailboxAndEmailChange = (MailboxAndEmailChange)jmapChange2;
            mono = this.mailboxChangeRepository().save(mailboxAndEmailChange.getMailboxChange()).then(this.emailChangeRepository().save(mailboxAndEmailChange.getEmailChange())).then(Mono.just((Object)jmapChange));
        } else {
            throw new MatchError((Object)jmapChange2);
        }
        return SMono$.MODULE$.apply((Publisher)mono);
    }

    private Publisher<Void> dispactChangeEvent(StateChangeEvent jmapChange) {
        return SMono$.MODULE$.apply((Publisher)this.eventBus().dispatch((Event)jmapChange, (RegistrationKey)new AccountIdRegistrationKey(AccountId.fromUsername((Username)jmapChange.getUsername()))));
    }

    private SMono<List<AccountId>> getSharees(MailboxId mailboxId, Username username) {
        MailboxSession session = this.mailboxManager().createSystemSession(username);
        return SMono$.MODULE$.apply(this.mailboxManager().getMailboxReactive(mailboxId, session)).map((Function1 & Serializable)mailbox -> mailbox.getResolvedAcl(session)).map((Function1 & Serializable)mailboxACL -> ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(mailboxACL.getEntries().keySet()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$getSharees$3(x$3)))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$getSharees$4(x$4)))).map((Function1 & Serializable)x$5 -> x$5.getName())).map((Function1 & Serializable)identifier -> AccountId.fromString((String)identifier))).toList()).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof MailboxNotFoundException) {
                MailboxChangeListener$.MODULE$.LOGGER().warn("Could not get sharees for mailbox {} as the mailbox was deleted", (Object)mailboxId);
                return SMono$.MODULE$.just((Object)package$.MODULE$.List().empty());
            }
            MailboxChangeListener$.MODULE$.LOGGER().warn("Could not get sharees for mailbox {} when listening to change events", (Object)mailboxId, (Object)throwable);
            return SMono$.MODULE$.just((Object)package$.MODULE$.List().empty());
        });
    }

    private StateChangeEvent toStateChangeEvent(JmapChange jmapChange) {
        JmapChange jmapChange2 = jmapChange;
        if (jmapChange2 instanceof EmailChange) {
            EmailChange emailChange = (EmailChange)jmapChange2;
            return new StateChangeEvent(Event.EventId.random(), Username.of((String)emailChange.getAccountId().getIdentifier()), this.emailStateMap(emailChange));
        }
        if (jmapChange2 instanceof MailboxChange) {
            MailboxChange mailboxChange = (MailboxChange)jmapChange2;
            return new StateChangeEvent(Event.EventId.random(), Username.of((String)mailboxChange.getAccountId().getIdentifier()), this.mailboxStateMap(mailboxChange));
        }
        if (jmapChange2 instanceof MailboxAndEmailChange) {
            MailboxAndEmailChange mailboxAndEmailChange = (MailboxAndEmailChange)jmapChange2;
            return new StateChangeEvent(Event.EventId.random(), Username.of((String)mailboxAndEmailChange.getAccountId().getIdentifier()), (Map<TypeName, State>)((Map)this.emailStateMap(mailboxAndEmailChange.getEmailChange()).$plus$plus(this.mailboxStateMap(mailboxAndEmailChange.getMailboxChange()))));
        }
        throw new MatchError((Object)jmapChange2);
    }

    private Map<TypeName, State> mailboxStateMap(MailboxChange mailboxChange) {
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MailboxTypeName$.MODULE$), (Object)UuidState$.MODULE$.fromJava(mailboxChange.getState()))}));
    }

    private Map<TypeName, State> emailStateMap(EmailChange emailChange) {
        return ((IterableOnceOps)((IterableOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EmailTypeName$.MODULE$), (Object)UuidState$.MODULE$.fromJava(emailChange.getState()))}))).$plus$plus((IterableOnce)new Some((Object)UuidState$.MODULE$.fromJava(emailChange.getState())).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$emailStateMap$1(emailChange, x$6))).map((Function1 & Serializable)emailDeliveryState -> (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EmailDeliveryTypeName$.MODULE$), emailDeliveryState)}))).getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public MailboxChangeListener copy(EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory mailboxChangeFactory, EmailChangeRepository emailChangeRepository, MailboxAndEmailChange.Factory emailChangeFactory, MailboxManager mailboxManager, Clock clock) {
        return new MailboxChangeListener(eventBus, mailboxChangeRepository, mailboxChangeFactory, emailChangeRepository, emailChangeFactory, mailboxManager, clock);
    }

    public EventBus copy$default$1() {
        return this.eventBus();
    }

    public MailboxChangeRepository copy$default$2() {
        return this.mailboxChangeRepository();
    }

    public MailboxChange.Factory copy$default$3() {
        return this.mailboxChangeFactory();
    }

    public EmailChangeRepository copy$default$4() {
        return this.emailChangeRepository();
    }

    public MailboxAndEmailChange.Factory copy$default$5() {
        return this.emailChangeFactory();
    }

    public MailboxManager copy$default$6() {
        return this.mailboxManager();
    }

    public Clock copy$default$7() {
        return this.clock();
    }

    public String productPrefix() {
        return "MailboxChangeListener";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.eventBus();
            }
            case 1: {
                return this.mailboxChangeRepository();
            }
            case 2: {
                return this.mailboxChangeFactory();
            }
            case 3: {
                return this.emailChangeRepository();
            }
            case 4: {
                return this.emailChangeFactory();
            }
            case 5: {
                return this.mailboxManager();
            }
            case 6: {
                return this.clock();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MailboxChangeListener;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "eventBus";
            }
            case 1: {
                return "mailboxChangeRepository";
            }
            case 2: {
                return "mailboxChangeFactory";
            }
            case 3: {
                return "emailChangeRepository";
            }
            case 4: {
                return "emailChangeFactory";
            }
            case 5: {
                return "mailboxManager";
            }
            case 6: {
                return "clock";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MailboxChangeListener)) return false;
        boolean bl = true;
        if (!bl) return false;
        MailboxChangeListener mailboxChangeListener = (MailboxChangeListener)x$1;
        EventBus eventBus = this.eventBus();
        EventBus eventBus2 = mailboxChangeListener.eventBus();
        if (eventBus == null) {
            if (eventBus2 != null) {
                return false;
            }
        } else if (!eventBus.equals(eventBus2)) return false;
        MailboxChangeRepository mailboxChangeRepository = this.mailboxChangeRepository();
        MailboxChangeRepository mailboxChangeRepository2 = mailboxChangeListener.mailboxChangeRepository();
        if (mailboxChangeRepository == null) {
            if (mailboxChangeRepository2 != null) {
                return false;
            }
        } else if (!mailboxChangeRepository.equals(mailboxChangeRepository2)) return false;
        MailboxChange.Factory factory = this.mailboxChangeFactory();
        MailboxChange.Factory factory2 = mailboxChangeListener.mailboxChangeFactory();
        if (factory == null) {
            if (factory2 != null) {
                return false;
            }
        } else if (!factory.equals(factory2)) return false;
        EmailChangeRepository emailChangeRepository = this.emailChangeRepository();
        EmailChangeRepository emailChangeRepository2 = mailboxChangeListener.emailChangeRepository();
        if (emailChangeRepository == null) {
            if (emailChangeRepository2 != null) {
                return false;
            }
        } else if (!emailChangeRepository.equals(emailChangeRepository2)) return false;
        MailboxAndEmailChange.Factory factory3 = this.emailChangeFactory();
        MailboxAndEmailChange.Factory factory4 = mailboxChangeListener.emailChangeFactory();
        if (factory3 == null) {
            if (factory4 != null) {
                return false;
            }
        } else if (!factory3.equals(factory4)) return false;
        MailboxManager mailboxManager = this.mailboxManager();
        MailboxManager mailboxManager2 = mailboxChangeListener.mailboxManager();
        if (mailboxManager == null) {
            if (mailboxManager2 != null) {
                return false;
            }
        } else if (!mailboxManager.equals(mailboxManager2)) return false;
        Clock clock = this.clock();
        Clock clock2 = mailboxChangeListener.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!((Object)clock).equals(clock2)) return false;
        if (!mailboxChangeListener.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getSharees$3(MailboxACL.EntryKey x$3) {
        return !x$3.isNegative();
    }

    public static final /* synthetic */ boolean $anonfun$getSharees$4(MailboxACL.EntryKey x$4) {
        MailboxACL.NameType nameType = x$4.getNameType();
        MailboxACL.NameType nameType2 = MailboxACL.NameType.user;
        return !(nameType != null ? !nameType.equals(nameType2) : nameType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$emailStateMap$1(EmailChange emailChange$1, UuidState x$6) {
        return emailChange$1.isDelivery() && !emailChange$1.getCreated().isEmpty();
    }

    @Inject
    public MailboxChangeListener(@Named(value="JMAP") EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory mailboxChangeFactory, EmailChangeRepository emailChangeRepository, MailboxAndEmailChange.Factory emailChangeFactory, MailboxManager mailboxManager, Clock clock) {
        this.eventBus = eventBus;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.mailboxChangeFactory = mailboxChangeFactory;
        this.emailChangeRepository = emailChangeRepository;
        this.emailChangeFactory = emailChangeFactory;
        this.mailboxManager = mailboxManager;
        this.clock = clock;
        Product.$init$((Product)this);
    }
}

