/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.api;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import reactor.core.publisher.Flux;

public interface RecipientRewriteTable {
    public static final EnumSet<Mapping.Type> listSourcesSupportedType = EnumSet.of(Mapping.Type.Group, new Mapping.Type[]{Mapping.Type.Forward, Mapping.Type.Address, Mapping.Type.Alias, Mapping.Type.Domain, Mapping.Type.DomainAlias});

    public void addMapping(MappingSource var1, Mapping var2) throws RecipientRewriteTableException;

    public void removeMapping(MappingSource var1, Mapping var2) throws RecipientRewriteTableException;

    public void addRegexMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeRegexMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addAddressMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeAddressMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addErrorMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeErrorMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addDomainMapping(MappingSource var1, Domain var2) throws RecipientRewriteTableException;

    public void removeDomainMapping(MappingSource var1, Domain var2) throws RecipientRewriteTableException;

    public void addDomainAliasMapping(MappingSource var1, Domain var2) throws RecipientRewriteTableException;

    public void removeDomainAliasMapping(MappingSource var1, Domain var2) throws RecipientRewriteTableException;

    public void addForwardMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeForwardMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addGroupMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeGroupMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addAliasMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeAliasMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    default public Mappings getResolvedMappings(String user, Domain domain) throws ErrorMappingException, RecipientRewriteTableException {
        return this.getResolvedMappings(user, domain, EnumSet.allOf(Mapping.Type.class));
    }

    public Mappings getResolvedMappings(String var1, Domain var2, EnumSet<Mapping.Type> var3) throws ErrorMappingException, RecipientRewriteTableException;

    public Mappings getStoredMappings(MappingSource var1) throws RecipientRewriteTableException;

    public Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException;

    public RecipientRewriteTableConfiguration getConfiguration();

    default public Stream<MappingSource> listSources(Mapping mapping) throws RecipientRewriteTableException {
        Preconditions.checkArgument((boolean)listSourcesSupportedType.contains((Object)mapping.getType()), (String)"Not supported mapping of type %s", (Object)((Object)mapping.getType()));
        return this.getAllMappings().entrySet().stream().filter(entry -> ((Mappings)entry.getValue()).contains(mapping)).map(Map.Entry::getKey);
    }

    default public Flux<MappingSource> listSourcesReactive(Mapping mapping) {
        try {
            return Flux.fromStream(this.listSources(mapping));
        }
        catch (RecipientRewriteTableException e) {
            return Flux.error((Throwable)e);
        }
    }

    default public Stream<MappingSource> getSourcesForType(Mapping.Type type) throws RecipientRewriteTableException {
        return this.getAllMappings().entrySet().stream().filter(e -> ((Mappings)e.getValue()).contains(type)).map(Map.Entry::getKey).sorted(Comparator.comparing(MappingSource::asMailAddressString));
    }

    default public Stream<Mapping> getMappingsForType(Mapping.Type type) throws RecipientRewriteTableException {
        return this.getAllMappings().values().stream().map(mappings -> mappings.select(type)).reduce(MappingsImpl.builder(), MappingsImpl.Builder::addAll, (builder1, builder2) -> builder1.addAll(builder2.build())).build().asStream().distinct();
    }

    public static class TooManyMappingException
    extends ErrorMappingException {
        public TooManyMappingException(String string) {
            super(string);
        }
    }

    public static class ErrorMappingException
    extends Exception {
        public ErrorMappingException(String string) {
            super(string);
        }
    }
}

