/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.forgerockds.controls;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

enum ControlMessages {
    ERR_AFFINITY_REQUEST_MISSING_VALUE("The provided control cannot be decoded as an affinity request control because it does not have a value."),
    ERR_CSN_REQUEST_HAS_VALUE("The provided control cannot be decoded as a change sequence number request control because it has a value."),
    ERR_CSN_RESPONSE_NO_VALUE("The provided control cannot be decoded as a change sequence number response control because it does not have a value."),
    ERR_REPLICATION_REPAIR_REQUEST_HAS_VALUE("The provided control cannot be decoded as a replication repair request control because it has a value."),
    ERR_TRANSACTION_ID_REQUEST_MISSING_VALUE("The provided control cannot be decoded as a transaction ID request control because it does not have a value."),
    INFO_CONTROL_NAME_AFFINITY_REQUEST("Affinity Request Control"),
    INFO_CONTROL_NAME_CSN_REQUEST("Change Sequence Number Request Control"),
    INFO_CONTROL_NAME_CSN_RESPONSE("Change Sequence Number Response Control"),
    INFO_CONTROL_NAME_REPLICATION_REPAIR_REQUEST("Replication Repair Request Control"),
    INFO_CONTROL_NAME_TRANSACTION_ID_REQUEST("Transaction ID Request Control");

    private static final boolean IS_WITHIN_UNIT_TESTS;
    private static final Object[] NO_ARGS;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<ControlMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<ControlMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private ControlMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(NO_ARGS);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(args);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    public String toString() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                s = this.defaultText;
            } else {
                try {
                    s = RESOURCE_BUNDLE.getString(this.name());
                }
                catch (Exception e) {
                    s = this.defaultText;
                }
                MESSAGE_STRINGS.putIfAbsent(this, s);
            }
        }
        return s;
    }

    static {
        IS_WITHIN_UNIT_TESTS = Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") || Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
        NO_ARGS = new Object[0];
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-forgerock-controls");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap(100);
        MESSAGES = new ConcurrentHashMap(100);
    }
}

