/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.other;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.other.DotNetGuid1Codec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;

public class DotNetGuid4Codec
implements UuidCodec<UUID> {
    public static final DotNetGuid4Codec INSTANCE = new DotNetGuid4Codec();

    @Override
    public UUID encode(UUID uuid) {
        UuidValidator.validate(uuid);
        if (!UuidUtil.isRandomBased(uuid)) {
            throw new InvalidUuidException(String.format("Not a random-based UUID: %s.", uuid.toString()));
        }
        return DotNetGuid1Codec.toAndFromDotNetGuid(uuid);
    }

    @Override
    public UUID decode(UUID uuid) {
        UuidValidator.validate(uuid);
        UUID uuidv4 = DotNetGuid1Codec.toAndFromDotNetGuid(uuid);
        if (!UuidUtil.isRandomBased(uuidv4)) {
            throw new InvalidUuidException(String.format("Not a random-based UUID: %s.", uuidv4.toString()));
        }
        return uuidv4;
    }
}

