/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DataTypeClassNameCompositeParser
extends DataTypeClassNameParser {
    public ParseResult parseWithComposite(String className, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userTypes, InternalDriverContext context) {
        DataTypeClassNameParser.Parser parser = new DataTypeClassNameParser.Parser(className, 0);
        String next = parser.parseNextName();
        if (!DataTypeClassNameCompositeParser.isComposite(next)) {
            return new ParseResult(this.parse(keyspaceId, className, userTypes, context), DataTypeClassNameCompositeParser.isReversed(next));
        }
        List<String> subClassNames = parser.getTypeParameters();
        int count = subClassNames.size();
        String last = subClassNames.get(count - 1);
        HashMap<String, DataType> collections = new HashMap<String, DataType>();
        if (DataTypeClassNameCompositeParser.isCollection(last)) {
            --count;
            DataTypeClassNameParser.Parser collectionParser = new DataTypeClassNameParser.Parser(last, 0);
            collectionParser.parseNextName();
            Map<String, String> params = collectionParser.getCollectionsParameters();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                collections.put(entry.getKey(), this.parse(keyspaceId, entry.getValue(), userTypes, context));
            }
        }
        ArrayList<DataType> types = new ArrayList<DataType>(count);
        ArrayList<Boolean> reversed = new ArrayList<Boolean>(count);
        for (int i = 0; i < count; ++i) {
            types.add(this.parse(keyspaceId, subClassNames.get(i), userTypes, context));
            reversed.add(DataTypeClassNameCompositeParser.isReversed(subClassNames.get(i)));
        }
        return new ParseResult(true, types, reversed, collections);
    }

    private static boolean isComposite(String className) {
        return className.startsWith("org.apache.cassandra.db.marshal.CompositeType");
    }

    private static boolean isCollection(String className) {
        return className.startsWith("org.apache.cassandra.db.marshal.ColumnToCollectionType");
    }

    public static class ParseResult {
        public final boolean isComposite;
        public final List<DataType> types;
        public final List<Boolean> reversed;
        public final Map<String, DataType> collections;

        private ParseResult(DataType type, boolean reversed) {
            this(false, Collections.singletonList(type), Collections.singletonList(reversed), Collections.emptyMap());
        }

        private ParseResult(boolean isComposite, List<DataType> types, List<Boolean> reversed, Map<String, DataType> collections) {
            this.isComposite = isComposite;
            this.types = types;
            this.reversed = reversed;
            this.collections = collections;
        }
    }
}

