/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.KuromojiTokenizationMode;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KuromojiTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant,
ToCopyableBuilder<Builder, KuromojiTokenizer> {
    @Nullable
    private final Boolean discardCompoundToken;
    @Nullable
    private final Boolean discardPunctuation;
    @Nonnull
    private final KuromojiTokenizationMode mode;
    @Nullable
    private final Integer nbestCost;
    @Nullable
    private final String nbestExamples;
    @Nullable
    private final String userDictionary;
    @Nonnull
    private final List<String> userDictionaryRules;
    public static final JsonpDeserializer<KuromojiTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiTokenizer::setupKuromojiTokenizerDeserializer);

    private KuromojiTokenizer(Builder builder) {
        super(builder);
        this.discardCompoundToken = builder.discardCompoundToken;
        this.discardPunctuation = builder.discardPunctuation;
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.nbestCost = builder.nbestCost;
        this.nbestExamples = builder.nbestExamples;
        this.userDictionary = builder.userDictionary;
        this.userDictionaryRules = ApiTypeHelper.unmodifiable(builder.userDictionaryRules);
    }

    public static KuromojiTokenizer of(Function<Builder, ObjectBuilder<KuromojiTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.KuromojiTokenizer;
    }

    @Nullable
    public final Boolean discardCompoundToken() {
        return this.discardCompoundToken;
    }

    @Nullable
    public final Boolean discardPunctuation() {
        return this.discardPunctuation;
    }

    @Nonnull
    public final KuromojiTokenizationMode mode() {
        return this.mode;
    }

    @Nullable
    public final Integer nbestCost() {
        return this.nbestCost;
    }

    @Nullable
    public final String nbestExamples() {
        return this.nbestExamples;
    }

    @Nullable
    public final String userDictionary() {
        return this.userDictionary;
    }

    @Nonnull
    public final List<String> userDictionaryRules() {
        return this.userDictionaryRules;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_tokenizer");
        super.serializeInternal(generator, mapper);
        if (this.discardCompoundToken != null) {
            generator.writeKey("discard_compound_token");
            generator.write(this.discardCompoundToken.booleanValue());
        }
        if (this.discardPunctuation != null) {
            generator.writeKey("discard_punctuation");
            generator.write(this.discardPunctuation.booleanValue());
        }
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        if (this.nbestCost != null) {
            generator.writeKey("nbest_cost");
            generator.write(this.nbestCost.intValue());
        }
        if (this.nbestExamples != null) {
            generator.writeKey("nbest_examples");
            generator.write(this.nbestExamples);
        }
        if (this.userDictionary != null) {
            generator.writeKey("user_dictionary");
            generator.write(this.userDictionary);
        }
        if (ApiTypeHelper.isDefined(this.userDictionaryRules)) {
            generator.writeKey("user_dictionary_rules");
            generator.writeStartArray();
            for (String item0 : this.userDictionaryRules) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKuromojiTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        KuromojiTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::discardCompoundToken, JsonpDeserializer.booleanDeserializer(), "discard_compound_token");
        op.add(Builder::discardPunctuation, JsonpDeserializer.booleanDeserializer(), "discard_punctuation");
        op.add(Builder::mode, KuromojiTokenizationMode._DESERIALIZER, "mode");
        op.add(Builder::nbestCost, JsonpDeserializer.integerDeserializer(), "nbest_cost");
        op.add(Builder::nbestExamples, JsonpDeserializer.stringDeserializer(), "nbest_examples");
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary");
        op.add(Builder::userDictionaryRules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "user_dictionary_rules");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.discardCompoundToken);
        result = 31 * result + Objects.hashCode(this.discardPunctuation);
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + Objects.hashCode(this.nbestCost);
        result = 31 * result + Objects.hashCode(this.nbestExamples);
        result = 31 * result + Objects.hashCode(this.userDictionary);
        result = 31 * result + Objects.hashCode(this.userDictionaryRules);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KuromojiTokenizer other = (KuromojiTokenizer)o;
        return Objects.equals(this.discardCompoundToken, other.discardCompoundToken) && Objects.equals(this.discardPunctuation, other.discardPunctuation) && this.mode.equals(other.mode) && Objects.equals(this.nbestCost, other.nbestCost) && Objects.equals(this.nbestExamples, other.nbestExamples) && Objects.equals(this.userDictionary, other.userDictionary) && Objects.equals(this.userDictionaryRules, other.userDictionaryRules);
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KuromojiTokenizer> {
        @Nullable
        private Boolean discardCompoundToken;
        @Nullable
        private Boolean discardPunctuation;
        private KuromojiTokenizationMode mode;
        @Nullable
        private Integer nbestCost;
        @Nullable
        private String nbestExamples;
        @Nullable
        private String userDictionary;
        @Nullable
        private List<String> userDictionaryRules;

        public Builder() {
        }

        private Builder(KuromojiTokenizer o) {
            super(o);
            this.discardCompoundToken = o.discardCompoundToken;
            this.discardPunctuation = o.discardPunctuation;
            this.mode = o.mode;
            this.nbestCost = o.nbestCost;
            this.nbestExamples = o.nbestExamples;
            this.userDictionary = o.userDictionary;
            this.userDictionaryRules = Builder._listCopy(o.userDictionaryRules);
        }

        private Builder(Builder o) {
            super(o);
            this.discardCompoundToken = o.discardCompoundToken;
            this.discardPunctuation = o.discardPunctuation;
            this.mode = o.mode;
            this.nbestCost = o.nbestCost;
            this.nbestExamples = o.nbestExamples;
            this.userDictionary = o.userDictionary;
            this.userDictionaryRules = Builder._listCopy(o.userDictionaryRules);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder discardCompoundToken(@Nullable Boolean value) {
            this.discardCompoundToken = value;
            return this;
        }

        @Nonnull
        public final Builder discardPunctuation(@Nullable Boolean value) {
            this.discardPunctuation = value;
            return this;
        }

        @Nonnull
        public final Builder mode(KuromojiTokenizationMode value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder nbestCost(@Nullable Integer value) {
            this.nbestCost = value;
            return this;
        }

        @Nonnull
        public final Builder nbestExamples(@Nullable String value) {
            this.nbestExamples = value;
            return this;
        }

        @Nonnull
        public final Builder userDictionary(@Nullable String value) {
            this.userDictionary = value;
            return this;
        }

        @Nonnull
        public final Builder userDictionaryRules(List<String> list) {
            this.userDictionaryRules = Builder._listAddAll(this.userDictionaryRules, list);
            return this;
        }

        @Nonnull
        public final Builder userDictionaryRules(String value, String ... values) {
            this.userDictionaryRules = Builder._listAdd(this.userDictionaryRules, value, values);
            return this;
        }

        @Override
        @Nonnull
        public KuromojiTokenizer build() {
            this._checkSingleUse();
            return new KuromojiTokenizer(this);
        }
    }
}

