/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.util.ObjectBuilder;

public abstract class IndicesResponseBase
extends AcknowledgedResponseBase {
    @Nullable
    private final ShardStatistics shards;

    protected IndicesResponseBase(AbstractBuilder<?> builder) {
        super(builder);
        this.shards = ((AbstractBuilder)builder).shards;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupIndicesResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        IndicesResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AcknowledgedResponseBase.AbstractBuilder<BuilderT> {
        @Nullable
        private ShardStatistics shards;

        public final BuilderT shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }
    }
}

