/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.ldap.LDAPConnectionFactory;
import org.apache.james.user.ldap.LdapHealthCheck;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepository;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class LdapUsersRepositoryModule
extends AbstractModule {
    public void configure() {
        this.bind(ReadOnlyUsersLDAPRepository.class).in(Scopes.SINGLETON);
        this.bind(UsersRepository.class).to(ReadOnlyUsersLDAPRepository.class);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(LdapHealthCheck.class);
    }

    @Provides
    @Singleton
    public LdapRepositoryConfiguration provideConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return LdapRepositoryConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("usersrepository"));
    }

    @Provides
    @Singleton
    public LDAPConnectionPool provideConfiguration(LdapRepositoryConfiguration configuration) throws LDAPException {
        return new LDAPConnectionFactory(configuration).getLdapConnectionPool();
    }

    @ProvidesIntoSet
    InitializationOperation configureLdap(ConfigurationProvider configurationProvider, ReadOnlyUsersLDAPRepository usersRepository) {
        return InitilizationOperationBuilder.forClass(ReadOnlyUsersLDAPRepository.class).init(() -> {
            usersRepository.configure(configurationProvider.getConfiguration("usersrepository"));
            usersRepository.init();
        });
    }
}

