/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jooq.impl.IntToIntFunction;

class KeywordLookup {
    private final KeywordTrie trie;

    KeywordLookup() {
        this(new KeywordTrie());
    }

    private KeywordLookup(KeywordTrie trie) {
        this.trie = trie;
    }

    static final KeywordLookup from(String ... keywords) {
        KeywordLookup result = new KeywordLookup();
        for (String keyword : keywords) {
            result.insert(keyword);
        }
        return result;
    }

    final int skipWhitespace(String text, int i) {
        int l = text.length();
        while (Character.isWhitespace(text.charAt(i)) && i + 1 < l) {
            ++i;
        }
        return i;
    }

    final boolean lookup(String text) {
        return this.lookup(text.toCharArray(), 0, i -> this.skipWhitespace(text, i)) == text.length();
    }

    final int lookup(char[] text, int position, IntToIntFunction afterWhitespace) {
        KeywordTrie t = this.trie;
        for (int i = position; i < text.length && t != null; ++i) {
            char c = KeywordLookup.upper(KeywordLookup.character(text, i));
            t = t.next[KeywordLookup.encode(c)];
            if (t == null) continue;
            if (t.terminal && !this.isIdentifierPart(KeywordLookup.character(text, i + 1)) && KeywordLookup.character(text, i + 1) != '.') {
                return i + 1;
            }
            if (!Character.isWhitespace(c)) continue;
            i = afterWhitespace.applyAsInt(i) - 1;
        }
        return position;
    }

    private final boolean isIdentifierPart(char character) {
        return Character.isJavaIdentifierPart(character) || (character == '@' || character == '#') && character != ';';
    }

    static final char character(char[] text, int pos) {
        return pos >= 0 && pos < text.length ? text[pos] : (char)' ';
    }

    final boolean insert(String keyword) {
        boolean result = false;
        KeywordTrie t = this.trie;
        for (int i = 0; i < keyword.length(); ++i) {
            int pos = KeywordLookup.encode(keyword.charAt(i));
            t = (result |= t.next[pos] == null) ? (t.next[pos] = new KeywordTrie()) : t.next[pos];
        }
        if (t.terminal) {
            return result;
        }
        t.terminal = true;
        return true;
    }

    final Set<String> set() {
        return KeywordLookup.set(new LinkedHashSet<String>(), new StringBuilder(), this.trie);
    }

    private static final int encode(char c) {
        if (c == ' ') {
            return 0;
        }
        char C = Character.toUpperCase(c);
        if (C >= 'A' && C <= 'Z') {
            return C - 64;
        }
        return 0;
    }

    private static final char decode(int i) {
        return i == 0 ? (char)' ' : (char)(i + 64);
    }

    private static final char upper(char c) {
        return c >= 'a' && c <= 'z' ? (char)(c - 32) : c;
    }

    private static final Set<String> set(Set<String> s, StringBuilder sb, KeywordTrie t) {
        if (t.terminal) {
            s.add(sb.toString());
        }
        for (int i = 0; i < t.next.length; ++i) {
            if (t.next[i] == null) continue;
            KeywordLookup.set(s, sb.append(KeywordLookup.decode(i)), t.next[i]);
            sb.deleteCharAt(sb.length() - 1);
        }
        return s;
    }

    public String toString() {
        return this.set().toString();
    }

    private static class KeywordTrie {
        final KeywordTrie[] next = new KeywordTrie[27];
        boolean terminal;

        private KeywordTrie() {
        }

        public String toString() {
            return "Terminal: " + this.terminal + ", Trie: " + new KeywordLookup(this).toString();
        }
    }
}

